/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_DUCT_LOSS_CONDUCTION_FIELDENUMS_HXX
#define UTILITIES_IDD_DUCT_LOSS_CONDUCTION_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Duct_Loss_ConductionFields
 *  \brief Enumeration of Duct:Loss:Conduction's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Duct_Loss_ConductionFields, )
#else
class Duct_Loss_ConductionFields: public ::EnumBase<Duct_Loss_ConductionFields> {
 public: 
  enum domain 
  {
Name, AirLoopHVACName, AirflowNetwork_Distribution_LinkageName, EnvironmentType, AmbientZoneName, AmbientTemperatureScheduleName, AmbientHumidityRatioScheduleName,   };
  Duct_Loss_ConductionFields()
   : EnumBase<Duct_Loss_ConductionFields>(Name) {} 
  Duct_Loss_ConductionFields(const std::string &t_name) 
   : EnumBase<Duct_Loss_ConductionFields>(t_name) {} 
  Duct_Loss_ConductionFields(int t_value) 
   : EnumBase<Duct_Loss_ConductionFields>(t_value) {} 
  static std::string enumName() 
  { return "Duct_Loss_ConductionFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Duct_Loss_ConductionFields>::integer_value()); }
   private:
    friend class EnumBase<Duct_Loss_ConductionFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Duct_Loss_ConductionFields::Name, "Name", "Name"},
{ Duct_Loss_ConductionFields::AirLoopHVACName, "AirLoopHVACName", "AirLoopHVAC Name"},
{ Duct_Loss_ConductionFields::AirflowNetwork_Distribution_LinkageName, "AirflowNetwork_Distribution_LinkageName", "AirflowNetwork:Distribution:Linkage Name"},
{ Duct_Loss_ConductionFields::EnvironmentType, "EnvironmentType", "Environment Type"},
{ Duct_Loss_ConductionFields::AmbientZoneName, "AmbientZoneName", "Ambient Zone Name"},
{ Duct_Loss_ConductionFields::AmbientTemperatureScheduleName, "AmbientTemperatureScheduleName", "Ambient Temperature Schedule Name"},
{ Duct_Loss_ConductionFields::AmbientHumidityRatioScheduleName, "AmbientHumidityRatioScheduleName", "Ambient Humidity Ratio Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Duct_Loss_ConductionFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Duct_Loss_ConductionFields> OptionalDuct_Loss_ConductionFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_DUCT_LOSS_CONDUCTION_FIELDENUMS_HXX
