/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_GROUNDHEATEXCHANGER_POND_FIELDENUMS_HXX
#define UTILITIES_IDD_GROUNDHEATEXCHANGER_POND_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class GroundHeatExchanger_PondFields
 *  \brief Enumeration of GroundHeatExchanger:Pond's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(GroundHeatExchanger_PondFields, )
#else
class GroundHeatExchanger_PondFields: public ::EnumBase<GroundHeatExchanger_PondFields> {
 public: 
  enum domain 
  {
Name, FluidInletNodeName, FluidOutletNodeName, PondDepth, PondArea, HydronicTubingInsideDiameter, HydronicTubingOutsideDiameter, HydronicTubingThermalConductivity, GroundThermalConductivity, NumberofTubingCircuits, LengthofEachTubingCircuit,   };
  GroundHeatExchanger_PondFields()
   : EnumBase<GroundHeatExchanger_PondFields>(Name) {} 
  GroundHeatExchanger_PondFields(const std::string &t_name) 
   : EnumBase<GroundHeatExchanger_PondFields>(t_name) {} 
  GroundHeatExchanger_PondFields(int t_value) 
   : EnumBase<GroundHeatExchanger_PondFields>(t_value) {} 
  static std::string enumName() 
  { return "GroundHeatExchanger_PondFields"; }
  domain value() const { return static_cast<domain>(EnumBase<GroundHeatExchanger_PondFields>::integer_value()); }
   private:
    friend class EnumBase<GroundHeatExchanger_PondFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ GroundHeatExchanger_PondFields::Name, "Name", "Name"},
{ GroundHeatExchanger_PondFields::FluidInletNodeName, "FluidInletNodeName", "Fluid Inlet Node Name"},
{ GroundHeatExchanger_PondFields::FluidOutletNodeName, "FluidOutletNodeName", "Fluid Outlet Node Name"},
{ GroundHeatExchanger_PondFields::PondDepth, "PondDepth", "Pond Depth"},
{ GroundHeatExchanger_PondFields::PondArea, "PondArea", "Pond Area"},
{ GroundHeatExchanger_PondFields::HydronicTubingInsideDiameter, "HydronicTubingInsideDiameter", "Hydronic Tubing Inside Diameter"},
{ GroundHeatExchanger_PondFields::HydronicTubingOutsideDiameter, "HydronicTubingOutsideDiameter", "Hydronic Tubing Outside Diameter"},
{ GroundHeatExchanger_PondFields::HydronicTubingThermalConductivity, "HydronicTubingThermalConductivity", "Hydronic Tubing Thermal Conductivity"},
{ GroundHeatExchanger_PondFields::GroundThermalConductivity, "GroundThermalConductivity", "Ground Thermal Conductivity"},
{ GroundHeatExchanger_PondFields::NumberofTubingCircuits, "NumberofTubingCircuits", "Number of Tubing Circuits"},
{ GroundHeatExchanger_PondFields::LengthofEachTubingCircuit, "LengthofEachTubingCircuit", "Length of Each Tubing Circuit"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const GroundHeatExchanger_PondFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<GroundHeatExchanger_PondFields> OptionalGroundHeatExchanger_PondFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_GROUNDHEATEXCHANGER_POND_FIELDENUMS_HXX
