/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_HeatPump_AirToWaterFields
 *  \brief Enumeration of OS:HeatPump:AirToWater's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_HeatPump_AirToWaterFields, )
#else
class OS_HeatPump_AirToWaterFields: public ::EnumBase<OS_HeatPump_AirToWaterFields> {
 public: 
  enum domain 
  {
Handle, Name, OperatingModeControlMethod, OperatingModeControlOptionforMultipleUnit, OperatingModeControlScheduleName, MinimumPartLoadRatio, AirInletNodeName, AirOutletNodeName, MaximumOutdoorDryBulbTemperatureForDefrostOperation, HeatPumpDefrostControl, HeatPumpDefrostTimePeriodFraction, ResistiveDefrostHeaterCapacity, DefrostEnergyInputRatioFunctionofTemperatureCurveName, HeatPumpMultiplier, ControlType, CrankcaseHeaterCapacity, CrankcaseHeaterCapacityFunctionofTemperatureCurveName, MaximumAmbientTemperatureforCrankcaseHeaterOperation, HeatingOperationMode, CoolingOperationMode,   };
  OS_HeatPump_AirToWaterFields()
   : EnumBase<OS_HeatPump_AirToWaterFields>(Handle) {} 
  OS_HeatPump_AirToWaterFields(const std::string &t_name) 
   : EnumBase<OS_HeatPump_AirToWaterFields>(t_name) {} 
  OS_HeatPump_AirToWaterFields(int t_value) 
   : EnumBase<OS_HeatPump_AirToWaterFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_HeatPump_AirToWaterFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_HeatPump_AirToWaterFields>::integer_value()); }
   private:
    friend class EnumBase<OS_HeatPump_AirToWaterFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_HeatPump_AirToWaterFields::Handle, "Handle", "Handle"},
{ OS_HeatPump_AirToWaterFields::Name, "Name", "Name"},
{ OS_HeatPump_AirToWaterFields::OperatingModeControlMethod, "OperatingModeControlMethod", "Operating Mode Control Method"},
{ OS_HeatPump_AirToWaterFields::OperatingModeControlOptionforMultipleUnit, "OperatingModeControlOptionforMultipleUnit", "Operating Mode Control Option for Multiple Unit"},
{ OS_HeatPump_AirToWaterFields::OperatingModeControlScheduleName, "OperatingModeControlScheduleName", "Operating Mode Control Schedule Name"},
{ OS_HeatPump_AirToWaterFields::MinimumPartLoadRatio, "MinimumPartLoadRatio", "Minimum Part Load Ratio"},
{ OS_HeatPump_AirToWaterFields::AirInletNodeName, "AirInletNodeName", "Air Inlet Node Name"},
{ OS_HeatPump_AirToWaterFields::AirOutletNodeName, "AirOutletNodeName", "Air Outlet Node Name"},
{ OS_HeatPump_AirToWaterFields::MaximumOutdoorDryBulbTemperatureForDefrostOperation, "MaximumOutdoorDryBulbTemperatureForDefrostOperation", "Maximum Outdoor Dry Bulb Temperature For Defrost Operation"},
{ OS_HeatPump_AirToWaterFields::HeatPumpDefrostControl, "HeatPumpDefrostControl", "Heat Pump Defrost Control"},
{ OS_HeatPump_AirToWaterFields::HeatPumpDefrostTimePeriodFraction, "HeatPumpDefrostTimePeriodFraction", "Heat Pump Defrost Time Period Fraction"},
{ OS_HeatPump_AirToWaterFields::ResistiveDefrostHeaterCapacity, "ResistiveDefrostHeaterCapacity", "Resistive Defrost Heater Capacity"},
{ OS_HeatPump_AirToWaterFields::DefrostEnergyInputRatioFunctionofTemperatureCurveName, "DefrostEnergyInputRatioFunctionofTemperatureCurveName", "Defrost Energy Input Ratio Function of Temperature Curve Name"},
{ OS_HeatPump_AirToWaterFields::HeatPumpMultiplier, "HeatPumpMultiplier", "Heat Pump Multiplier"},
{ OS_HeatPump_AirToWaterFields::ControlType, "ControlType", "Control Type"},
{ OS_HeatPump_AirToWaterFields::CrankcaseHeaterCapacity, "CrankcaseHeaterCapacity", "Crankcase Heater Capacity"},
{ OS_HeatPump_AirToWaterFields::CrankcaseHeaterCapacityFunctionofTemperatureCurveName, "CrankcaseHeaterCapacityFunctionofTemperatureCurveName", "Crankcase Heater Capacity Function of Temperature Curve Name"},
{ OS_HeatPump_AirToWaterFields::MaximumAmbientTemperatureforCrankcaseHeaterOperation, "MaximumAmbientTemperatureforCrankcaseHeaterOperation", "Maximum Ambient Temperature for Crankcase Heater Operation"},
{ OS_HeatPump_AirToWaterFields::HeatingOperationMode, "HeatingOperationMode", "Heating Operation Mode"},
{ OS_HeatPump_AirToWaterFields::CoolingOperationMode, "CoolingOperationMode", "Cooling Operation Mode"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_HeatPump_AirToWaterFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_HeatPump_AirToWaterFields> OptionalOS_HeatPump_AirToWaterFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_FIELDENUMS_HXX
