/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_SETPOINTMANAGER_FOLLOWOUTDOORAIRTEMPERATURE_FIELDENUMS_HXX
#define UTILITIES_IDD_SETPOINTMANAGER_FOLLOWOUTDOORAIRTEMPERATURE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class SetpointManager_FollowOutdoorAirTemperatureFields
 *  \brief Enumeration of SetpointManager:FollowOutdoorAirTemperature's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(SetpointManager_FollowOutdoorAirTemperatureFields, )
#else
class SetpointManager_FollowOutdoorAirTemperatureFields: public ::EnumBase<SetpointManager_FollowOutdoorAirTemperatureFields> {
 public: 
  enum domain 
  {
Name, ControlVariable, ReferenceTemperatureType, OffsetTemperatureDifference, MaximumSetpointTemperature, MinimumSetpointTemperature, SetpointNodeorNodeListName,   };
  SetpointManager_FollowOutdoorAirTemperatureFields()
   : EnumBase<SetpointManager_FollowOutdoorAirTemperatureFields>(Name) {} 
  SetpointManager_FollowOutdoorAirTemperatureFields(const std::string &t_name) 
   : EnumBase<SetpointManager_FollowOutdoorAirTemperatureFields>(t_name) {} 
  SetpointManager_FollowOutdoorAirTemperatureFields(int t_value) 
   : EnumBase<SetpointManager_FollowOutdoorAirTemperatureFields>(t_value) {} 
  static std::string enumName() 
  { return "SetpointManager_FollowOutdoorAirTemperatureFields"; }
  domain value() const { return static_cast<domain>(EnumBase<SetpointManager_FollowOutdoorAirTemperatureFields>::integer_value()); }
   private:
    friend class EnumBase<SetpointManager_FollowOutdoorAirTemperatureFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ SetpointManager_FollowOutdoorAirTemperatureFields::Name, "Name", "Name"},
{ SetpointManager_FollowOutdoorAirTemperatureFields::ControlVariable, "ControlVariable", "Control Variable"},
{ SetpointManager_FollowOutdoorAirTemperatureFields::ReferenceTemperatureType, "ReferenceTemperatureType", "Reference Temperature Type"},
{ SetpointManager_FollowOutdoorAirTemperatureFields::OffsetTemperatureDifference, "OffsetTemperatureDifference", "Offset Temperature Difference"},
{ SetpointManager_FollowOutdoorAirTemperatureFields::MaximumSetpointTemperature, "MaximumSetpointTemperature", "Maximum Setpoint Temperature"},
{ SetpointManager_FollowOutdoorAirTemperatureFields::MinimumSetpointTemperature, "MinimumSetpointTemperature", "Minimum Setpoint Temperature"},
{ SetpointManager_FollowOutdoorAirTemperatureFields::SetpointNodeorNodeListName, "SetpointNodeorNodeListName", "Setpoint Node or NodeList Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const SetpointManager_FollowOutdoorAirTemperatureFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<SetpointManager_FollowOutdoorAirTemperatureFields> OptionalSetpointManager_FollowOutdoorAirTemperatureFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_SETPOINTMANAGER_FOLLOWOUTDOORAIRTEMPERATURE_FIELDENUMS_HXX
