/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_ZONEGROUP_FIELDENUMS_HXX
#define UTILITIES_IDD_ZONEGROUP_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ZoneGroupFields
 *  \brief Enumeration of ZoneGroup's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ZoneGroupFields, )
#else
class ZoneGroupFields: public ::EnumBase<ZoneGroupFields> {
 public: 
  enum domain 
  {
Name, ZoneListName, ZoneListMultiplier,   };
  ZoneGroupFields()
   : EnumBase<ZoneGroupFields>(Name) {} 
  ZoneGroupFields(const std::string &t_name) 
   : EnumBase<ZoneGroupFields>(t_name) {} 
  ZoneGroupFields(int t_value) 
   : EnumBase<ZoneGroupFields>(t_value) {} 
  static std::string enumName() 
  { return "ZoneGroupFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ZoneGroupFields>::integer_value()); }
   private:
    friend class EnumBase<ZoneGroupFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ZoneGroupFields::Name, "Name", "Name"},
{ ZoneGroupFields::ZoneListName, "ZoneListName", "Zone List Name"},
{ ZoneGroupFields::ZoneListMultiplier, "ZoneListMultiplier", "Zone List Multiplier"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ZoneGroupFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ZoneGroupFields> OptionalZoneGroupFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_ZONEGROUP_FIELDENUMS_HXX
