/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_COOLING_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_COOLING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_HeatPump_AirToWater_CoolingFields
 *  \brief Enumeration of OS:HeatPump:AirToWater:Cooling's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_HeatPump_AirToWater_CoolingFields, )
#else
class OS_HeatPump_AirToWater_CoolingFields: public ::EnumBase<OS_HeatPump_AirToWater_CoolingFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilityScheduleName, RatedInletAirTemperature, RatedAirFlowRate, RatedLeavingWaterTemperature, RatedWaterFlowRate, MinimumOutdoorAirTemperature, MaximumOutdoorAirTemperature, MinimumLeavingWaterTemperatureCurveName, MaximumLeavingWaterTemperatureCurveName, SizingFactor, ChilledWaterInletNodeName, ChilledWaterOutletNodeName, SpeedDataList, BoosterModeOnSpeed,   };
  OS_HeatPump_AirToWater_CoolingFields()
   : EnumBase<OS_HeatPump_AirToWater_CoolingFields>(Handle) {} 
  OS_HeatPump_AirToWater_CoolingFields(const std::string &t_name) 
   : EnumBase<OS_HeatPump_AirToWater_CoolingFields>(t_name) {} 
  OS_HeatPump_AirToWater_CoolingFields(int t_value) 
   : EnumBase<OS_HeatPump_AirToWater_CoolingFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_HeatPump_AirToWater_CoolingFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_HeatPump_AirToWater_CoolingFields>::integer_value()); }
   private:
    friend class EnumBase<OS_HeatPump_AirToWater_CoolingFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_HeatPump_AirToWater_CoolingFields::Handle, "Handle", "Handle"},
{ OS_HeatPump_AirToWater_CoolingFields::Name, "Name", "Name"},
{ OS_HeatPump_AirToWater_CoolingFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ OS_HeatPump_AirToWater_CoolingFields::RatedInletAirTemperature, "RatedInletAirTemperature", "Rated Inlet Air Temperature"},
{ OS_HeatPump_AirToWater_CoolingFields::RatedAirFlowRate, "RatedAirFlowRate", "Rated Air Flow Rate"},
{ OS_HeatPump_AirToWater_CoolingFields::RatedLeavingWaterTemperature, "RatedLeavingWaterTemperature", "Rated Leaving Water Temperature"},
{ OS_HeatPump_AirToWater_CoolingFields::RatedWaterFlowRate, "RatedWaterFlowRate", "Rated Water Flow Rate"},
{ OS_HeatPump_AirToWater_CoolingFields::MinimumOutdoorAirTemperature, "MinimumOutdoorAirTemperature", "Minimum Outdoor Air Temperature"},
{ OS_HeatPump_AirToWater_CoolingFields::MaximumOutdoorAirTemperature, "MaximumOutdoorAirTemperature", "Maximum Outdoor Air Temperature"},
{ OS_HeatPump_AirToWater_CoolingFields::MinimumLeavingWaterTemperatureCurveName, "MinimumLeavingWaterTemperatureCurveName", "Minimum Leaving Water Temperature Curve Name"},
{ OS_HeatPump_AirToWater_CoolingFields::MaximumLeavingWaterTemperatureCurveName, "MaximumLeavingWaterTemperatureCurveName", "Maximum Leaving Water Temperature Curve Name"},
{ OS_HeatPump_AirToWater_CoolingFields::SizingFactor, "SizingFactor", "Sizing Factor"},
{ OS_HeatPump_AirToWater_CoolingFields::ChilledWaterInletNodeName, "ChilledWaterInletNodeName", "Chilled Water Inlet Node Name"},
{ OS_HeatPump_AirToWater_CoolingFields::ChilledWaterOutletNodeName, "ChilledWaterOutletNodeName", "Chilled Water Outlet Node Name"},
{ OS_HeatPump_AirToWater_CoolingFields::SpeedDataList, "SpeedDataList", "Speed Data List"},
{ OS_HeatPump_AirToWater_CoolingFields::BoosterModeOnSpeed, "BoosterModeOnSpeed", "Booster Mode On Speed"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_HeatPump_AirToWater_CoolingFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_HeatPump_AirToWater_CoolingFields> OptionalOS_HeatPump_AirToWater_CoolingFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_COOLING_FIELDENUMS_HXX
