/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Sustainable Energy, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SIZINGPERIOD_WEATHERFILECONDITIONTYPE_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SIZINGPERIOD_WEATHERFILECONDITIONTYPE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SizingPeriod_WeatherFileConditionTypeFields
 *  \brief Enumeration of OS:SizingPeriod:WeatherFileConditionType's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SizingPeriod_WeatherFileConditionTypeFields, )
#else
class OS_SizingPeriod_WeatherFileConditionTypeFields: public ::EnumBase<OS_SizingPeriod_WeatherFileConditionTypeFields> {
 public: 
  enum domain 
  {
Handle, Name, PeriodSelection, DayofWeekforStartDay, UseWeatherFileDaylightSavingPeriod, UseWeatherFileRainandSnowIndicators,   };
  OS_SizingPeriod_WeatherFileConditionTypeFields()
   : EnumBase<OS_SizingPeriod_WeatherFileConditionTypeFields>(Handle) {} 
  OS_SizingPeriod_WeatherFileConditionTypeFields(const std::string &t_name) 
   : EnumBase<OS_SizingPeriod_WeatherFileConditionTypeFields>(t_name) {} 
  OS_SizingPeriod_WeatherFileConditionTypeFields(int t_value) 
   : EnumBase<OS_SizingPeriod_WeatherFileConditionTypeFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SizingPeriod_WeatherFileConditionTypeFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SizingPeriod_WeatherFileConditionTypeFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SizingPeriod_WeatherFileConditionTypeFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SizingPeriod_WeatherFileConditionTypeFields::Handle, "Handle", "Handle"},
{ OS_SizingPeriod_WeatherFileConditionTypeFields::Name, "Name", "Name"},
{ OS_SizingPeriod_WeatherFileConditionTypeFields::PeriodSelection, "PeriodSelection", "Period Selection"},
{ OS_SizingPeriod_WeatherFileConditionTypeFields::DayofWeekforStartDay, "DayofWeekforStartDay", "Day of Week for Start Day"},
{ OS_SizingPeriod_WeatherFileConditionTypeFields::UseWeatherFileDaylightSavingPeriod, "UseWeatherFileDaylightSavingPeriod", "Use Weather File Daylight Saving Period"},
{ OS_SizingPeriod_WeatherFileConditionTypeFields::UseWeatherFileRainandSnowIndicators, "UseWeatherFileRainandSnowIndicators", "Use Weather File Rain and Snow Indicators"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SizingPeriod_WeatherFileConditionTypeFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SizingPeriod_WeatherFileConditionTypeFields> OptionalOS_SizingPeriod_WeatherFileConditionTypeFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SIZINGPERIOD_WEATHERFILECONDITIONTYPE_FIELDENUMS_HXX
