/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_THERMALSTORAGE_SIZING_FIELDENUMS_HXX
#define UTILITIES_IDD_THERMALSTORAGE_SIZING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ThermalStorage_SizingFields
 *  \brief Enumeration of ThermalStorage:Sizing's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ThermalStorage_SizingFields, )
#else
class ThermalStorage_SizingFields: public ::EnumBase<ThermalStorage_SizingFields> {
 public: 
  enum domain 
  {
Name, OnPeakPeriodStartTime, OnPeakPeriodEndTime, SizingFactor,   };
  ThermalStorage_SizingFields()
   : EnumBase<ThermalStorage_SizingFields>(Name) {} 
  ThermalStorage_SizingFields(const std::string &t_name) 
   : EnumBase<ThermalStorage_SizingFields>(t_name) {} 
  ThermalStorage_SizingFields(int t_value) 
   : EnumBase<ThermalStorage_SizingFields>(t_value) {} 
  static std::string enumName() 
  { return "ThermalStorage_SizingFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ThermalStorage_SizingFields>::integer_value()); }
   private:
    friend class EnumBase<ThermalStorage_SizingFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ThermalStorage_SizingFields::Name, "Name", "Name"},
{ ThermalStorage_SizingFields::OnPeakPeriodStartTime, "OnPeakPeriodStartTime", "On Peak Period Start Time"},
{ ThermalStorage_SizingFields::OnPeakPeriodEndTime, "OnPeakPeriodEndTime", "On Peak Period End Time"},
{ ThermalStorage_SizingFields::SizingFactor, "SizingFactor", "Sizing Factor"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ThermalStorage_SizingFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ThermalStorage_SizingFields> OptionalThermalStorage_SizingFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_THERMALSTORAGE_SIZING_FIELDENUMS_HXX
