/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AVAILABILITYMANAGER_HIGHTEMPERATURETURNON_FIELDENUMS_HXX
#define UTILITIES_IDD_AVAILABILITYMANAGER_HIGHTEMPERATURETURNON_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AvailabilityManager_HighTemperatureTurnOnFields
 *  \brief Enumeration of AvailabilityManager:HighTemperatureTurnOn's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AvailabilityManager_HighTemperatureTurnOnFields, )
#else
class AvailabilityManager_HighTemperatureTurnOnFields: public ::EnumBase<AvailabilityManager_HighTemperatureTurnOnFields> {
 public: 
  enum domain 
  {
Name, SensorNodeName, Temperature,   };
  AvailabilityManager_HighTemperatureTurnOnFields()
   : EnumBase<AvailabilityManager_HighTemperatureTurnOnFields>(Name) {} 
  AvailabilityManager_HighTemperatureTurnOnFields(const std::string &t_name) 
   : EnumBase<AvailabilityManager_HighTemperatureTurnOnFields>(t_name) {} 
  AvailabilityManager_HighTemperatureTurnOnFields(int t_value) 
   : EnumBase<AvailabilityManager_HighTemperatureTurnOnFields>(t_value) {} 
  static std::string enumName() 
  { return "AvailabilityManager_HighTemperatureTurnOnFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AvailabilityManager_HighTemperatureTurnOnFields>::integer_value()); }
   private:
    friend class EnumBase<AvailabilityManager_HighTemperatureTurnOnFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AvailabilityManager_HighTemperatureTurnOnFields::Name, "Name", "Name"},
{ AvailabilityManager_HighTemperatureTurnOnFields::SensorNodeName, "SensorNodeName", "Sensor Node Name"},
{ AvailabilityManager_HighTemperatureTurnOnFields::Temperature, "Temperature", "Temperature"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AvailabilityManager_HighTemperatureTurnOnFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AvailabilityManager_HighTemperatureTurnOnFields> OptionalAvailabilityManager_HighTemperatureTurnOnFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AVAILABILITYMANAGER_HIGHTEMPERATURETURNON_FIELDENUMS_HXX
