/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_HEATPUMP_AIRTOWATER_FIELDENUMS_HXX
#define UTILITIES_IDD_HEATPUMP_AIRTOWATER_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class HeatPump_AirToWaterFields
 *  \brief Enumeration of HeatPump:AirToWater's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(HeatPump_AirToWaterFields, )
#else
class HeatPump_AirToWaterFields: public ::EnumBase<HeatPump_AirToWaterFields> {
 public: 
  enum domain 
  {
Name, AvailabilityScheduleNameHeating, AvailabilityScheduleNameCooling, OperatingModeControlMethod, OperatingModeControlOptionforMultipleUnit, OperatingModeControlScheduleName, MinimumPartLoadRatio, RatedInletAirTemperatureinHeatingMode, RatedAirFlowRateinHeatingMode, RatedLeavingWaterTemperatureinHeatingMode, RatedWaterFlowRateinHeatingMode, MinimumOutdoorAirTemperatureinHeatingMode, MaximumOutdoorAirTemperatureinHeatingMode, MinimumLeavingWaterTemperatureCurveNameinHeatingMode, MaximumLeavingWaterTemperatureCurveNameinHeatingMode, SizingFactorforHeating, RatedInletAirTemperatureinCoolingMode, RatedAirFlowRateinCoolingMode, RatedLeavingWaterTemperatureinCoolingMode, RatedWaterFlowRateinCoolingMode, MinimumOutdoorAirTemperatureinCoolingMode, MaximumOutdoorAirTemperatureinCoolingMode, MinimumLeavingWaterTemperatureCurveNameinCoolingMode, MaximumLeavingWaterTemperatureCurveNameinCoolingMode, SizingFactorforCooling, AirInletNodeName, AirOutletNodeName, HotWaterInletNodeName, HotWaterOutletNodeName, ChilledWaterInletNodeName, ChilledWaterOutletNodeName, MaximumOutdoorDryBulbTemperatureForDefrostOperation, HeatPumpDefrostControl, HeatPumpDefrostTimePeriodFraction, ResistiveDefrostHeaterCapacity, DefrostEnergyInputRatioFunctionofTemperatureCurveName, HeatPumpMultiplier, ControlType, CrankcaseHeaterCapacity, CrankcaseHeaterCapacityFunctionofTemperatureCurveName, MaximumAmbientTemperatureforCrankcaseHeaterOperation, NumberofSpeedsforHeating, RatedHeatingCapacityatSpeed1, RatedCOPforHeatingatSpeed1, NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed1, HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed1, HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed1, RatedHeatingCapacityatSpeed2, RatedCOPforHeatingatSpeed2, NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed2, HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed2, HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed2, RatedHeatingCapacityatSpeed3, RatedCOPforHeatingatSpeed3, NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed3, HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed3, HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed3, RatedHeatingCapacityatSpeed4, RatedCOPforHeatingatSpeed4, NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed4, HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed4, HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed4, RatedHeatingCapacityatSpeed5, RatedCOPforHeatingatSpeed5, NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed5, HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed5, HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed5, BoosterModeOnHeating, RatedHeatingCapacityinBoosterMode, RatedHeatingCOPinBoosterMode, NormalizedHeatingCapacityFunctionofTemperatureCurveNameinBoosterMode, HeatingEnergyInputRatioFunctionofTemperatureCurveNameinBoosterMode, HeatingEnergyInputRatioFunctionofPLRCurveNameinBoosterMode, NumberofSpeedsforCooling, RatedCoolingCapacityatSpeed1, RatedCOPforCoolingatSpeed1, NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed1, CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed1, CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed1, RatedCoolingCapacityatSpeed2, RatedCOPforCoolingatSpeed2, NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed2, CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed2, CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed2, RatedCoolingCapacityatSpeed3, RatedCOPforCoolingatSpeed3, NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed3, CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed3, CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed3, RatedCoolingCapacityatSpeed4, RatedCOPforCoolingatSpeed4, NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed4, CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed4, CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed4, RatedCoolingCapacityatSpeed5, RatedCOPforCoolingatSpeed5, NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed5, CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed5, CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed5, BoosterModeOnCooling, RatedCoolingCapacityinBoosterMode, RatedCoolingCOPinBoosterMode, NormalizedCoolingCapacityFunctionofTemperatureCurveNameinBoosterMode, CoolingEnergyInputRatioFunctionofTemperatureCurveNameinBoosterMode, CoolingEnergyInputRatioFunctionofPLRCurveNameinBoosterMode,   };
  HeatPump_AirToWaterFields()
   : EnumBase<HeatPump_AirToWaterFields>(Name) {} 
  HeatPump_AirToWaterFields(const std::string &t_name) 
   : EnumBase<HeatPump_AirToWaterFields>(t_name) {} 
  HeatPump_AirToWaterFields(int t_value) 
   : EnumBase<HeatPump_AirToWaterFields>(t_value) {} 
  static std::string enumName() 
  { return "HeatPump_AirToWaterFields"; }
  domain value() const { return static_cast<domain>(EnumBase<HeatPump_AirToWaterFields>::integer_value()); }
   private:
    friend class EnumBase<HeatPump_AirToWaterFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ HeatPump_AirToWaterFields::Name, "Name", "Name"},
{ HeatPump_AirToWaterFields::AvailabilityScheduleNameHeating, "AvailabilityScheduleNameHeating", "Availability Schedule Name Heating"},
{ HeatPump_AirToWaterFields::AvailabilityScheduleNameCooling, "AvailabilityScheduleNameCooling", "Availability Schedule Name Cooling"},
{ HeatPump_AirToWaterFields::OperatingModeControlMethod, "OperatingModeControlMethod", "Operating Mode Control Method"},
{ HeatPump_AirToWaterFields::OperatingModeControlOptionforMultipleUnit, "OperatingModeControlOptionforMultipleUnit", "Operating Mode Control Option for Multiple Unit"},
{ HeatPump_AirToWaterFields::OperatingModeControlScheduleName, "OperatingModeControlScheduleName", "Operating Mode Control Schedule Name"},
{ HeatPump_AirToWaterFields::MinimumPartLoadRatio, "MinimumPartLoadRatio", "Minimum Part Load Ratio"},
{ HeatPump_AirToWaterFields::RatedInletAirTemperatureinHeatingMode, "RatedInletAirTemperatureinHeatingMode", "Rated Inlet Air Temperature in Heating Mode"},
{ HeatPump_AirToWaterFields::RatedAirFlowRateinHeatingMode, "RatedAirFlowRateinHeatingMode", "Rated Air Flow Rate in Heating Mode"},
{ HeatPump_AirToWaterFields::RatedLeavingWaterTemperatureinHeatingMode, "RatedLeavingWaterTemperatureinHeatingMode", "Rated Leaving Water Temperature in Heating Mode"},
{ HeatPump_AirToWaterFields::RatedWaterFlowRateinHeatingMode, "RatedWaterFlowRateinHeatingMode", "Rated Water Flow Rate in Heating Mode"},
{ HeatPump_AirToWaterFields::MinimumOutdoorAirTemperatureinHeatingMode, "MinimumOutdoorAirTemperatureinHeatingMode", "Minimum Outdoor Air Temperature in Heating Mode"},
{ HeatPump_AirToWaterFields::MaximumOutdoorAirTemperatureinHeatingMode, "MaximumOutdoorAirTemperatureinHeatingMode", "Maximum Outdoor Air Temperature in Heating Mode"},
{ HeatPump_AirToWaterFields::MinimumLeavingWaterTemperatureCurveNameinHeatingMode, "MinimumLeavingWaterTemperatureCurveNameinHeatingMode", "Minimum Leaving Water Temperature Curve Name in Heating Mode"},
{ HeatPump_AirToWaterFields::MaximumLeavingWaterTemperatureCurveNameinHeatingMode, "MaximumLeavingWaterTemperatureCurveNameinHeatingMode", "Maximum Leaving Water Temperature Curve Name in Heating Mode"},
{ HeatPump_AirToWaterFields::SizingFactorforHeating, "SizingFactorforHeating", "Sizing Factor for Heating"},
{ HeatPump_AirToWaterFields::RatedInletAirTemperatureinCoolingMode, "RatedInletAirTemperatureinCoolingMode", "Rated Inlet Air Temperature in Cooling Mode"},
{ HeatPump_AirToWaterFields::RatedAirFlowRateinCoolingMode, "RatedAirFlowRateinCoolingMode", "Rated Air Flow Rate in Cooling Mode"},
{ HeatPump_AirToWaterFields::RatedLeavingWaterTemperatureinCoolingMode, "RatedLeavingWaterTemperatureinCoolingMode", "Rated Leaving Water Temperature in Cooling Mode"},
{ HeatPump_AirToWaterFields::RatedWaterFlowRateinCoolingMode, "RatedWaterFlowRateinCoolingMode", "Rated Water Flow Rate in Cooling Mode"},
{ HeatPump_AirToWaterFields::MinimumOutdoorAirTemperatureinCoolingMode, "MinimumOutdoorAirTemperatureinCoolingMode", "Minimum Outdoor Air Temperature in Cooling Mode"},
{ HeatPump_AirToWaterFields::MaximumOutdoorAirTemperatureinCoolingMode, "MaximumOutdoorAirTemperatureinCoolingMode", "Maximum Outdoor Air Temperature in Cooling Mode"},
{ HeatPump_AirToWaterFields::MinimumLeavingWaterTemperatureCurveNameinCoolingMode, "MinimumLeavingWaterTemperatureCurveNameinCoolingMode", "Minimum Leaving Water Temperature Curve Name in Cooling Mode"},
{ HeatPump_AirToWaterFields::MaximumLeavingWaterTemperatureCurveNameinCoolingMode, "MaximumLeavingWaterTemperatureCurveNameinCoolingMode", "Maximum Leaving Water Temperature Curve Name in Cooling Mode"},
{ HeatPump_AirToWaterFields::SizingFactorforCooling, "SizingFactorforCooling", "Sizing Factor for Cooling"},
{ HeatPump_AirToWaterFields::AirInletNodeName, "AirInletNodeName", "Air Inlet Node Name"},
{ HeatPump_AirToWaterFields::AirOutletNodeName, "AirOutletNodeName", "Air Outlet Node Name"},
{ HeatPump_AirToWaterFields::HotWaterInletNodeName, "HotWaterInletNodeName", "Hot Water Inlet Node Name"},
{ HeatPump_AirToWaterFields::HotWaterOutletNodeName, "HotWaterOutletNodeName", "Hot Water Outlet Node Name"},
{ HeatPump_AirToWaterFields::ChilledWaterInletNodeName, "ChilledWaterInletNodeName", "Chilled Water Inlet Node Name"},
{ HeatPump_AirToWaterFields::ChilledWaterOutletNodeName, "ChilledWaterOutletNodeName", "Chilled Water Outlet Node Name"},
{ HeatPump_AirToWaterFields::MaximumOutdoorDryBulbTemperatureForDefrostOperation, "MaximumOutdoorDryBulbTemperatureForDefrostOperation", "Maximum Outdoor Dry Bulb Temperature For Defrost Operation"},
{ HeatPump_AirToWaterFields::HeatPumpDefrostControl, "HeatPumpDefrostControl", "Heat Pump Defrost Control"},
{ HeatPump_AirToWaterFields::HeatPumpDefrostTimePeriodFraction, "HeatPumpDefrostTimePeriodFraction", "Heat Pump Defrost Time Period Fraction"},
{ HeatPump_AirToWaterFields::ResistiveDefrostHeaterCapacity, "ResistiveDefrostHeaterCapacity", "Resistive Defrost Heater Capacity"},
{ HeatPump_AirToWaterFields::DefrostEnergyInputRatioFunctionofTemperatureCurveName, "DefrostEnergyInputRatioFunctionofTemperatureCurveName", "Defrost Energy Input Ratio Function of Temperature Curve Name"},
{ HeatPump_AirToWaterFields::HeatPumpMultiplier, "HeatPumpMultiplier", "Heat Pump Multiplier"},
{ HeatPump_AirToWaterFields::ControlType, "ControlType", "Control Type"},
{ HeatPump_AirToWaterFields::CrankcaseHeaterCapacity, "CrankcaseHeaterCapacity", "Crankcase Heater Capacity"},
{ HeatPump_AirToWaterFields::CrankcaseHeaterCapacityFunctionofTemperatureCurveName, "CrankcaseHeaterCapacityFunctionofTemperatureCurveName", "Crankcase Heater Capacity Function of Temperature Curve Name"},
{ HeatPump_AirToWaterFields::MaximumAmbientTemperatureforCrankcaseHeaterOperation, "MaximumAmbientTemperatureforCrankcaseHeaterOperation", "Maximum Ambient Temperature for Crankcase Heater Operation"},
{ HeatPump_AirToWaterFields::NumberofSpeedsforHeating, "NumberofSpeedsforHeating", "Number of Speeds for Heating"},
{ HeatPump_AirToWaterFields::RatedHeatingCapacityatSpeed1, "RatedHeatingCapacityatSpeed1", "Rated Heating Capacity at Speed 1"},
{ HeatPump_AirToWaterFields::RatedCOPforHeatingatSpeed1, "RatedCOPforHeatingatSpeed1", "Rated COP for Heating at Speed 1"},
{ HeatPump_AirToWaterFields::NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed1, "NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed1", "Normalized Heating Capacity Function of Temperature Curve Name at Speed 1"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed1, "HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed1", "Heating Energy Input Ratio Function of Temperature Curve Name at Speed 1"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed1, "HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed1", "Heating Energy Input Ratio Function of PLR Curve Name at Speed 1"},
{ HeatPump_AirToWaterFields::RatedHeatingCapacityatSpeed2, "RatedHeatingCapacityatSpeed2", "Rated Heating Capacity at Speed 2"},
{ HeatPump_AirToWaterFields::RatedCOPforHeatingatSpeed2, "RatedCOPforHeatingatSpeed2", "Rated COP for Heating at Speed 2"},
{ HeatPump_AirToWaterFields::NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed2, "NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed2", "Normalized Heating Capacity Function of Temperature Curve Name at Speed 2"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed2, "HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed2", "Heating Energy Input Ratio Function of Temperature Curve Name at Speed 2"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed2, "HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed2", "Heating Energy Input Ratio Function of PLR Curve Name at Speed 2"},
{ HeatPump_AirToWaterFields::RatedHeatingCapacityatSpeed3, "RatedHeatingCapacityatSpeed3", "Rated Heating Capacity at Speed 3"},
{ HeatPump_AirToWaterFields::RatedCOPforHeatingatSpeed3, "RatedCOPforHeatingatSpeed3", "Rated COP for Heating at Speed 3"},
{ HeatPump_AirToWaterFields::NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed3, "NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed3", "Normalized Heating Capacity Function of Temperature Curve Name at Speed 3"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed3, "HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed3", "Heating Energy Input Ratio Function of Temperature Curve Name at Speed 3"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed3, "HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed3", "Heating Energy Input Ratio Function of PLR Curve Name at Speed 3"},
{ HeatPump_AirToWaterFields::RatedHeatingCapacityatSpeed4, "RatedHeatingCapacityatSpeed4", "Rated Heating Capacity at Speed 4"},
{ HeatPump_AirToWaterFields::RatedCOPforHeatingatSpeed4, "RatedCOPforHeatingatSpeed4", "Rated COP for Heating at Speed 4"},
{ HeatPump_AirToWaterFields::NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed4, "NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed4", "Normalized Heating Capacity Function of Temperature Curve Name at Speed 4"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed4, "HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed4", "Heating Energy Input Ratio Function of Temperature Curve Name at Speed 4"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed4, "HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed4", "Heating Energy Input Ratio Function of PLR Curve Name at Speed 4"},
{ HeatPump_AirToWaterFields::RatedHeatingCapacityatSpeed5, "RatedHeatingCapacityatSpeed5", "Rated Heating Capacity at Speed 5"},
{ HeatPump_AirToWaterFields::RatedCOPforHeatingatSpeed5, "RatedCOPforHeatingatSpeed5", "Rated COP for Heating at Speed 5"},
{ HeatPump_AirToWaterFields::NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed5, "NormalizedHeatingCapacityFunctionofTemperatureCurveNameatSpeed5", "Normalized Heating Capacity Function of Temperature Curve Name at Speed 5"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed5, "HeatingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed5", "Heating Energy Input Ratio Function of Temperature Curve Name at Speed 5"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed5, "HeatingEnergyInputRatioFunctionofPLRCurveNameatSpeed5", "Heating Energy Input Ratio Function of PLR Curve Name at Speed 5"},
{ HeatPump_AirToWaterFields::BoosterModeOnHeating, "BoosterModeOnHeating", "Booster Mode On Heating"},
{ HeatPump_AirToWaterFields::RatedHeatingCapacityinBoosterMode, "RatedHeatingCapacityinBoosterMode", "Rated Heating Capacity in Booster Mode"},
{ HeatPump_AirToWaterFields::RatedHeatingCOPinBoosterMode, "RatedHeatingCOPinBoosterMode", "Rated Heating COP in Booster Mode"},
{ HeatPump_AirToWaterFields::NormalizedHeatingCapacityFunctionofTemperatureCurveNameinBoosterMode, "NormalizedHeatingCapacityFunctionofTemperatureCurveNameinBoosterMode", "Normalized Heating Capacity Function of Temperature Curve Name in Booster Mode"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofTemperatureCurveNameinBoosterMode, "HeatingEnergyInputRatioFunctionofTemperatureCurveNameinBoosterMode", "Heating Energy Input Ratio Function of Temperature Curve Name in Booster Mode"},
{ HeatPump_AirToWaterFields::HeatingEnergyInputRatioFunctionofPLRCurveNameinBoosterMode, "HeatingEnergyInputRatioFunctionofPLRCurveNameinBoosterMode", "Heating Energy Input Ratio Function of PLR Curve Name in Booster Mode"},
{ HeatPump_AirToWaterFields::NumberofSpeedsforCooling, "NumberofSpeedsforCooling", "Number of Speeds for Cooling"},
{ HeatPump_AirToWaterFields::RatedCoolingCapacityatSpeed1, "RatedCoolingCapacityatSpeed1", "Rated Cooling Capacity at Speed 1"},
{ HeatPump_AirToWaterFields::RatedCOPforCoolingatSpeed1, "RatedCOPforCoolingatSpeed1", "Rated COP for Cooling at Speed 1"},
{ HeatPump_AirToWaterFields::NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed1, "NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed1", "Normalized Cooling Capacity Function of Temperature Curve Name at Speed 1"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed1, "CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed1", "Cooling Energy Input Ratio Function of Temperature Curve Name at Speed 1"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed1, "CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed1", "Cooling Energy Input Ratio Function of PLR Curve Name at Speed 1"},
{ HeatPump_AirToWaterFields::RatedCoolingCapacityatSpeed2, "RatedCoolingCapacityatSpeed2", "Rated Cooling Capacity at Speed 2"},
{ HeatPump_AirToWaterFields::RatedCOPforCoolingatSpeed2, "RatedCOPforCoolingatSpeed2", "Rated COP for Cooling at Speed 2"},
{ HeatPump_AirToWaterFields::NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed2, "NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed2", "Normalized Cooling Capacity Function of Temperature Curve Name at Speed 2"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed2, "CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed2", "Cooling Energy Input Ratio Function of Temperature Curve Name at Speed 2"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed2, "CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed2", "Cooling Energy Input Ratio Function of PLR Curve Name at Speed 2"},
{ HeatPump_AirToWaterFields::RatedCoolingCapacityatSpeed3, "RatedCoolingCapacityatSpeed3", "Rated Cooling Capacity at Speed 3"},
{ HeatPump_AirToWaterFields::RatedCOPforCoolingatSpeed3, "RatedCOPforCoolingatSpeed3", "Rated COP for Cooling at Speed 3"},
{ HeatPump_AirToWaterFields::NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed3, "NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed3", "Normalized Cooling Capacity Function of Temperature Curve Name at Speed 3"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed3, "CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed3", "Cooling Energy Input Ratio Function of Temperature Curve Name at Speed 3"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed3, "CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed3", "Cooling Energy Input Ratio Function of PLR Curve Name at Speed 3"},
{ HeatPump_AirToWaterFields::RatedCoolingCapacityatSpeed4, "RatedCoolingCapacityatSpeed4", "Rated Cooling Capacity at Speed 4"},
{ HeatPump_AirToWaterFields::RatedCOPforCoolingatSpeed4, "RatedCOPforCoolingatSpeed4", "Rated COP for Cooling at Speed 4"},
{ HeatPump_AirToWaterFields::NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed4, "NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed4", "Normalized Cooling Capacity Function of Temperature Curve Name at Speed 4"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed4, "CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed4", "Cooling Energy Input Ratio Function of Temperature Curve Name at Speed 4"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed4, "CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed4", "Cooling Energy Input Ratio Function of PLR Curve Name at Speed 4"},
{ HeatPump_AirToWaterFields::RatedCoolingCapacityatSpeed5, "RatedCoolingCapacityatSpeed5", "Rated Cooling Capacity at Speed 5"},
{ HeatPump_AirToWaterFields::RatedCOPforCoolingatSpeed5, "RatedCOPforCoolingatSpeed5", "Rated COP for Cooling at Speed 5"},
{ HeatPump_AirToWaterFields::NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed5, "NormalizedCoolingCapacityFunctionofTemperatureCurveNameatSpeed5", "Normalized Cooling Capacity Function of Temperature Curve Name at Speed 5"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed5, "CoolingEnergyInputRatioFunctionofTemperatureCurveNameatSpeed5", "Cooling Energy Input Ratio Function of Temperature Curve Name at Speed 5"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed5, "CoolingEnergyInputRatioFunctionofPLRCurveNameatSpeed5", "Cooling Energy Input Ratio Function of PLR Curve Name at Speed 5"},
{ HeatPump_AirToWaterFields::BoosterModeOnCooling, "BoosterModeOnCooling", "Booster Mode On Cooling"},
{ HeatPump_AirToWaterFields::RatedCoolingCapacityinBoosterMode, "RatedCoolingCapacityinBoosterMode", "Rated Cooling Capacity in Booster Mode"},
{ HeatPump_AirToWaterFields::RatedCoolingCOPinBoosterMode, "RatedCoolingCOPinBoosterMode", "Rated Cooling COP in Booster Mode"},
{ HeatPump_AirToWaterFields::NormalizedCoolingCapacityFunctionofTemperatureCurveNameinBoosterMode, "NormalizedCoolingCapacityFunctionofTemperatureCurveNameinBoosterMode", "Normalized Cooling Capacity Function of Temperature Curve Name in Booster Mode"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofTemperatureCurveNameinBoosterMode, "CoolingEnergyInputRatioFunctionofTemperatureCurveNameinBoosterMode", "Cooling Energy Input Ratio Function of Temperature Curve Name in Booster Mode"},
{ HeatPump_AirToWaterFields::CoolingEnergyInputRatioFunctionofPLRCurveNameinBoosterMode, "CoolingEnergyInputRatioFunctionofPLRCurveNameinBoosterMode", "Cooling Energy Input Ratio Function of PLR Curve Name in Booster Mode"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const HeatPump_AirToWaterFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<HeatPump_AirToWaterFields> OptionalHeatPump_AirToWaterFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_HEATPUMP_AIRTOWATER_FIELDENUMS_HXX
