/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_COIL_COOLING_DX_MULTISPEED_STAGEDATA_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_COIL_COOLING_DX_MULTISPEED_STAGEDATA_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Coil_Cooling_DX_MultiSpeed_StageDataFields
 *  \brief Enumeration of OS:Coil:Cooling:DX:MultiSpeed:StageData's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Coil_Cooling_DX_MultiSpeed_StageDataFields, )
#else
class OS_Coil_Cooling_DX_MultiSpeed_StageDataFields: public ::EnumBase<OS_Coil_Cooling_DX_MultiSpeed_StageDataFields> {
 public: 
  enum domain 
  {
Handle, Name, GrossRatedTotalCoolingCapacity, GrossRatedSensibleHeatRatio, GrossRatedCoolingCOP, RatedAirFlowRate, RatedEvaporatorFanPowerPerVolumeFlowRate2017, RatedEvaporatorFanPowerPerVolumeFlowRate2023, TotalCoolingCapacityFunctionofTemperatureCurve, TotalCoolingCapacityFunctionofFlowFractionCurve, EnergyInputRatioFunctionofTemperatureCurve, EnergyInputRatioFunctionofFlowFractionCurve, PartLoadFractionCorrelationCurve, NominalTimeforCondensateRemovaltoBegin, RatioofInitialMoistureEvaporationRateandSteadyStateLatentCapacity, MaximumCyclingRate, LatentCapacityTimeConstant, RatedWasteHeatFractionofPowerInput, WasteHeatFunctionofTemperatureCurve, EvaporativeCondenserEffectiveness, EvaporativeCondenserAirFlowRate, RatedEvaporativeCondenserPumpPowerConsumption,   };
  OS_Coil_Cooling_DX_MultiSpeed_StageDataFields()
   : EnumBase<OS_Coil_Cooling_DX_MultiSpeed_StageDataFields>(Handle) {} 
  OS_Coil_Cooling_DX_MultiSpeed_StageDataFields(const std::string &t_name) 
   : EnumBase<OS_Coil_Cooling_DX_MultiSpeed_StageDataFields>(t_name) {} 
  OS_Coil_Cooling_DX_MultiSpeed_StageDataFields(int t_value) 
   : EnumBase<OS_Coil_Cooling_DX_MultiSpeed_StageDataFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Coil_Cooling_DX_MultiSpeed_StageDataFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Coil_Cooling_DX_MultiSpeed_StageDataFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Coil_Cooling_DX_MultiSpeed_StageDataFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::Handle, "Handle", "Handle"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::Name, "Name", "Name"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::GrossRatedTotalCoolingCapacity, "GrossRatedTotalCoolingCapacity", "Gross Rated Total Cooling Capacity"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::GrossRatedSensibleHeatRatio, "GrossRatedSensibleHeatRatio", "Gross Rated Sensible Heat Ratio"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::GrossRatedCoolingCOP, "GrossRatedCoolingCOP", "Gross Rated Cooling COP"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::RatedAirFlowRate, "RatedAirFlowRate", "Rated Air Flow Rate"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::RatedEvaporatorFanPowerPerVolumeFlowRate2017, "RatedEvaporatorFanPowerPerVolumeFlowRate2017", "Rated Evaporator Fan Power Per Volume Flow Rate 2017"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::RatedEvaporatorFanPowerPerVolumeFlowRate2023, "RatedEvaporatorFanPowerPerVolumeFlowRate2023", "Rated Evaporator Fan Power Per Volume Flow Rate 2023"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::TotalCoolingCapacityFunctionofTemperatureCurve, "TotalCoolingCapacityFunctionofTemperatureCurve", "Total Cooling Capacity Function of Temperature Curve"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::TotalCoolingCapacityFunctionofFlowFractionCurve, "TotalCoolingCapacityFunctionofFlowFractionCurve", "Total Cooling Capacity Function of Flow Fraction Curve"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::EnergyInputRatioFunctionofTemperatureCurve, "EnergyInputRatioFunctionofTemperatureCurve", "Energy Input Ratio Function of Temperature Curve"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::EnergyInputRatioFunctionofFlowFractionCurve, "EnergyInputRatioFunctionofFlowFractionCurve", "Energy Input Ratio Function of Flow Fraction Curve"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::PartLoadFractionCorrelationCurve, "PartLoadFractionCorrelationCurve", "Part Load Fraction Correlation Curve"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::NominalTimeforCondensateRemovaltoBegin, "NominalTimeforCondensateRemovaltoBegin", "Nominal Time for Condensate Removal to Begin"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::RatioofInitialMoistureEvaporationRateandSteadyStateLatentCapacity, "RatioofInitialMoistureEvaporationRateandSteadyStateLatentCapacity", "Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::MaximumCyclingRate, "MaximumCyclingRate", "Maximum Cycling Rate"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::LatentCapacityTimeConstant, "LatentCapacityTimeConstant", "Latent Capacity Time Constant"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::RatedWasteHeatFractionofPowerInput, "RatedWasteHeatFractionofPowerInput", "Rated Waste Heat Fraction of Power Input"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::WasteHeatFunctionofTemperatureCurve, "WasteHeatFunctionofTemperatureCurve", "Waste Heat Function of Temperature Curve"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::EvaporativeCondenserEffectiveness, "EvaporativeCondenserEffectiveness", "Evaporative Condenser Effectiveness"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::EvaporativeCondenserAirFlowRate, "EvaporativeCondenserAirFlowRate", "Evaporative Condenser Air Flow Rate"},
{ OS_Coil_Cooling_DX_MultiSpeed_StageDataFields::RatedEvaporativeCondenserPumpPowerConsumption, "RatedEvaporativeCondenserPumpPowerConsumption", "Rated Evaporative Condenser Pump Power Consumption"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Coil_Cooling_DX_MultiSpeed_StageDataFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Coil_Cooling_DX_MultiSpeed_StageDataFields> OptionalOS_Coil_Cooling_DX_MultiSpeed_StageDataFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_COIL_COOLING_DX_MULTISPEED_STAGEDATA_FIELDENUMS_HXX
