/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_COIL_HEATING_GAS_MULTISTAGE_STAGEDATA_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_COIL_HEATING_GAS_MULTISTAGE_STAGEDATA_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Coil_Heating_Gas_MultiStage_StageDataFields
 *  \brief Enumeration of OS:Coil:Heating:Gas:MultiStage:StageData's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Coil_Heating_Gas_MultiStage_StageDataFields, )
#else
class OS_Coil_Heating_Gas_MultiStage_StageDataFields: public ::EnumBase<OS_Coil_Heating_Gas_MultiStage_StageDataFields> {
 public: 
  enum domain 
  {
Handle, Name, GasBurnerEfficiency, NominalCapacity, OnCycleParasiticElectricLoad,   };
  OS_Coil_Heating_Gas_MultiStage_StageDataFields()
   : EnumBase<OS_Coil_Heating_Gas_MultiStage_StageDataFields>(Handle) {} 
  OS_Coil_Heating_Gas_MultiStage_StageDataFields(const std::string &t_name) 
   : EnumBase<OS_Coil_Heating_Gas_MultiStage_StageDataFields>(t_name) {} 
  OS_Coil_Heating_Gas_MultiStage_StageDataFields(int t_value) 
   : EnumBase<OS_Coil_Heating_Gas_MultiStage_StageDataFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Coil_Heating_Gas_MultiStage_StageDataFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Coil_Heating_Gas_MultiStage_StageDataFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Coil_Heating_Gas_MultiStage_StageDataFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Coil_Heating_Gas_MultiStage_StageDataFields::Handle, "Handle", "Handle"},
{ OS_Coil_Heating_Gas_MultiStage_StageDataFields::Name, "Name", "Name"},
{ OS_Coil_Heating_Gas_MultiStage_StageDataFields::GasBurnerEfficiency, "GasBurnerEfficiency", "Gas Burner Efficiency"},
{ OS_Coil_Heating_Gas_MultiStage_StageDataFields::NominalCapacity, "NominalCapacity", "Nominal Capacity"},
{ OS_Coil_Heating_Gas_MultiStage_StageDataFields::OnCycleParasiticElectricLoad, "OnCycleParasiticElectricLoad", "On Cycle Parasitic Electric Load"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Coil_Heating_Gas_MultiStage_StageDataFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Coil_Heating_Gas_MultiStage_StageDataFields> OptionalOS_Coil_Heating_Gas_MultiStage_StageDataFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_COIL_HEATING_GAS_MULTISTAGE_STAGEDATA_FIELDENUMS_HXX
