/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_CURVE_QUADRATICLINEAR_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_CURVE_QUADRATICLINEAR_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Curve_QuadraticLinearFields
 *  \brief Enumeration of OS:Curve:QuadraticLinear's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Curve_QuadraticLinearFields, )
#else
class OS_Curve_QuadraticLinearFields: public ::EnumBase<OS_Curve_QuadraticLinearFields> {
 public: 
  enum domain 
  {
Handle, Name, Coefficient1Constant, Coefficient2x, Coefficient3x_POW_2, Coefficient4y, Coefficient5x_TIMES_y, Coefficient6x_POW_2_TIMES_y, MinimumValueofx, MaximumValueofx, MinimumValueofy, MaximumValueofy, MinimumCurveOutput, MaximumCurveOutput, InputUnitTypeforX, InputUnitTypeforY, OutputUnitType,   };
  OS_Curve_QuadraticLinearFields()
   : EnumBase<OS_Curve_QuadraticLinearFields>(Handle) {} 
  OS_Curve_QuadraticLinearFields(const std::string &t_name) 
   : EnumBase<OS_Curve_QuadraticLinearFields>(t_name) {} 
  OS_Curve_QuadraticLinearFields(int t_value) 
   : EnumBase<OS_Curve_QuadraticLinearFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Curve_QuadraticLinearFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Curve_QuadraticLinearFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Curve_QuadraticLinearFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Curve_QuadraticLinearFields::Handle, "Handle", "Handle"},
{ OS_Curve_QuadraticLinearFields::Name, "Name", "Name"},
{ OS_Curve_QuadraticLinearFields::Coefficient1Constant, "Coefficient1Constant", "Coefficient1 Constant"},
{ OS_Curve_QuadraticLinearFields::Coefficient2x, "Coefficient2x", "Coefficient2 x"},
{ OS_Curve_QuadraticLinearFields::Coefficient3x_POW_2, "Coefficient3x_POW_2", "Coefficient3 x**2"},
{ OS_Curve_QuadraticLinearFields::Coefficient4y, "Coefficient4y", "Coefficient4 y"},
{ OS_Curve_QuadraticLinearFields::Coefficient5x_TIMES_y, "Coefficient5x_TIMES_y", "Coefficient5 x*y"},
{ OS_Curve_QuadraticLinearFields::Coefficient6x_POW_2_TIMES_y, "Coefficient6x_POW_2_TIMES_y", "Coefficient6 x**2*y"},
{ OS_Curve_QuadraticLinearFields::MinimumValueofx, "MinimumValueofx", "Minimum Value of x"},
{ OS_Curve_QuadraticLinearFields::MaximumValueofx, "MaximumValueofx", "Maximum Value of x"},
{ OS_Curve_QuadraticLinearFields::MinimumValueofy, "MinimumValueofy", "Minimum Value of y"},
{ OS_Curve_QuadraticLinearFields::MaximumValueofy, "MaximumValueofy", "Maximum Value of y"},
{ OS_Curve_QuadraticLinearFields::MinimumCurveOutput, "MinimumCurveOutput", "Minimum Curve Output"},
{ OS_Curve_QuadraticLinearFields::MaximumCurveOutput, "MaximumCurveOutput", "Maximum Curve Output"},
{ OS_Curve_QuadraticLinearFields::InputUnitTypeforX, "InputUnitTypeforX", "Input Unit Type for X"},
{ OS_Curve_QuadraticLinearFields::InputUnitTypeforY, "InputUnitTypeforY", "Input Unit Type for Y"},
{ OS_Curve_QuadraticLinearFields::OutputUnitType, "OutputUnitType", "Output Unit Type"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Curve_QuadraticLinearFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Curve_QuadraticLinearFields> OptionalOS_Curve_QuadraticLinearFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_CURVE_QUADRATICLINEAR_FIELDENUMS_HXX
