/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_REFRIGERATION_SUBCOOLER_MECHANICAL_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_REFRIGERATION_SUBCOOLER_MECHANICAL_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Refrigeration_Subcooler_MechanicalFields
 *  \brief Enumeration of OS:Refrigeration:Subcooler:Mechanical's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Refrigeration_Subcooler_MechanicalFields, )
#else
class OS_Refrigeration_Subcooler_MechanicalFields: public ::EnumBase<OS_Refrigeration_Subcooler_MechanicalFields> {
 public: 
  enum domain 
  {
Handle, Name, CapacityProvidingSystem, OutletControlTemperature,   };
  OS_Refrigeration_Subcooler_MechanicalFields()
   : EnumBase<OS_Refrigeration_Subcooler_MechanicalFields>(Handle) {} 
  OS_Refrigeration_Subcooler_MechanicalFields(const std::string &t_name) 
   : EnumBase<OS_Refrigeration_Subcooler_MechanicalFields>(t_name) {} 
  OS_Refrigeration_Subcooler_MechanicalFields(int t_value) 
   : EnumBase<OS_Refrigeration_Subcooler_MechanicalFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Refrigeration_Subcooler_MechanicalFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Refrigeration_Subcooler_MechanicalFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Refrigeration_Subcooler_MechanicalFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Refrigeration_Subcooler_MechanicalFields::Handle, "Handle", "Handle"},
{ OS_Refrigeration_Subcooler_MechanicalFields::Name, "Name", "Name"},
{ OS_Refrigeration_Subcooler_MechanicalFields::CapacityProvidingSystem, "CapacityProvidingSystem", "Capacity-Providing System"},
{ OS_Refrigeration_Subcooler_MechanicalFields::OutletControlTemperature, "OutletControlTemperature", "Outlet Control Temperature"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Refrigeration_Subcooler_MechanicalFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Refrigeration_Subcooler_MechanicalFields> OptionalOS_Refrigeration_Subcooler_MechanicalFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_REFRIGERATION_SUBCOOLER_MECHANICAL_FIELDENUMS_HXX
