/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_STEAMEQUIPMENT_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_STEAMEQUIPMENT_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SteamEquipmentFields
 *  \brief Enumeration of OS:SteamEquipment's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SteamEquipmentFields, )
#else
class OS_SteamEquipmentFields: public ::EnumBase<OS_SteamEquipmentFields> {
 public: 
  enum domain 
  {
Handle, Name, SteamEquipmentDefinitionName, SpaceorSpaceTypeName, ScheduleName, Multiplier, EndUseSubcategory,   };
  OS_SteamEquipmentFields()
   : EnumBase<OS_SteamEquipmentFields>(Handle) {} 
  OS_SteamEquipmentFields(const std::string &t_name) 
   : EnumBase<OS_SteamEquipmentFields>(t_name) {} 
  OS_SteamEquipmentFields(int t_value) 
   : EnumBase<OS_SteamEquipmentFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SteamEquipmentFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SteamEquipmentFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SteamEquipmentFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SteamEquipmentFields::Handle, "Handle", "Handle"},
{ OS_SteamEquipmentFields::Name, "Name", "Name"},
{ OS_SteamEquipmentFields::SteamEquipmentDefinitionName, "SteamEquipmentDefinitionName", "Steam Equipment Definition Name"},
{ OS_SteamEquipmentFields::SpaceorSpaceTypeName, "SpaceorSpaceTypeName", "Space or SpaceType Name"},
{ OS_SteamEquipmentFields::ScheduleName, "ScheduleName", "Schedule Name"},
{ OS_SteamEquipmentFields::Multiplier, "Multiplier", "Multiplier"},
{ OS_SteamEquipmentFields::EndUseSubcategory, "EndUseSubcategory", "End-Use Subcategory"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SteamEquipmentFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SteamEquipmentFields> OptionalOS_SteamEquipmentFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_STEAMEQUIPMENT_FIELDENUMS_HXX
