/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_PIPE_ADIABATIC_STEAM_FIELDENUMS_HXX
#define UTILITIES_IDD_PIPE_ADIABATIC_STEAM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Pipe_Adiabatic_SteamFields
 *  \brief Enumeration of Pipe:Adiabatic:Steam's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Pipe_Adiabatic_SteamFields, )
#else
class Pipe_Adiabatic_SteamFields: public ::EnumBase<Pipe_Adiabatic_SteamFields> {
 public: 
  enum domain 
  {
Name, InletNodeName, OutletNodeName,   };
  Pipe_Adiabatic_SteamFields()
   : EnumBase<Pipe_Adiabatic_SteamFields>(Name) {} 
  Pipe_Adiabatic_SteamFields(const std::string &t_name) 
   : EnumBase<Pipe_Adiabatic_SteamFields>(t_name) {} 
  Pipe_Adiabatic_SteamFields(int t_value) 
   : EnumBase<Pipe_Adiabatic_SteamFields>(t_value) {} 
  static std::string enumName() 
  { return "Pipe_Adiabatic_SteamFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Pipe_Adiabatic_SteamFields>::integer_value()); }
   private:
    friend class EnumBase<Pipe_Adiabatic_SteamFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Pipe_Adiabatic_SteamFields::Name, "Name", "Name"},
{ Pipe_Adiabatic_SteamFields::InletNodeName, "InletNodeName", "Inlet Node Name"},
{ Pipe_Adiabatic_SteamFields::OutletNodeName, "OutletNodeName", "Outlet Node Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Pipe_Adiabatic_SteamFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Pipe_Adiabatic_SteamFields> OptionalPipe_Adiabatic_SteamFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_PIPE_ADIABATIC_STEAM_FIELDENUMS_HXX
