/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_SETPOINTMANAGER_SCHEDULED_FIELDENUMS_HXX
#define UTILITIES_IDD_SETPOINTMANAGER_SCHEDULED_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class SetpointManager_ScheduledFields
 *  \brief Enumeration of SetpointManager:Scheduled's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(SetpointManager_ScheduledFields, )
#else
class SetpointManager_ScheduledFields: public ::EnumBase<SetpointManager_ScheduledFields> {
 public: 
  enum domain 
  {
Name, ControlVariable, ScheduleName, SetpointNodeorNodeListName,   };
  SetpointManager_ScheduledFields()
   : EnumBase<SetpointManager_ScheduledFields>(Name) {} 
  SetpointManager_ScheduledFields(const std::string &t_name) 
   : EnumBase<SetpointManager_ScheduledFields>(t_name) {} 
  SetpointManager_ScheduledFields(int t_value) 
   : EnumBase<SetpointManager_ScheduledFields>(t_value) {} 
  static std::string enumName() 
  { return "SetpointManager_ScheduledFields"; }
  domain value() const { return static_cast<domain>(EnumBase<SetpointManager_ScheduledFields>::integer_value()); }
   private:
    friend class EnumBase<SetpointManager_ScheduledFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ SetpointManager_ScheduledFields::Name, "Name", "Name"},
{ SetpointManager_ScheduledFields::ControlVariable, "ControlVariable", "Control Variable"},
{ SetpointManager_ScheduledFields::ScheduleName, "ScheduleName", "Schedule Name"},
{ SetpointManager_ScheduledFields::SetpointNodeorNodeListName, "SetpointNodeorNodeListName", "Setpoint Node or NodeList Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const SetpointManager_ScheduledFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<SetpointManager_ScheduledFields> OptionalSetpointManager_ScheduledFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_SETPOINTMANAGER_SCHEDULED_FIELDENUMS_HXX
