/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_UTILITYCOST_CHARGE_BLOCK_FIELDENUMS_HXX
#define UTILITIES_IDD_UTILITYCOST_CHARGE_BLOCK_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class UtilityCost_Charge_BlockFields
 *  \brief Enumeration of UtilityCost:Charge:Block's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(UtilityCost_Charge_BlockFields, )
#else
class UtilityCost_Charge_BlockFields: public ::EnumBase<UtilityCost_Charge_BlockFields> {
 public: 
  enum domain 
  {
UtilityCostChargeBlockName, TariffName, SourceVariable, Season, CategoryVariableName, RemainingIntoVariable, BlockSizeMultiplierValueorVariableName,   };
  UtilityCost_Charge_BlockFields()
   : EnumBase<UtilityCost_Charge_BlockFields>(UtilityCostChargeBlockName) {} 
  UtilityCost_Charge_BlockFields(const std::string &t_name) 
   : EnumBase<UtilityCost_Charge_BlockFields>(t_name) {} 
  UtilityCost_Charge_BlockFields(int t_value) 
   : EnumBase<UtilityCost_Charge_BlockFields>(t_value) {} 
  static std::string enumName() 
  { return "UtilityCost_Charge_BlockFields"; }
  domain value() const { return static_cast<domain>(EnumBase<UtilityCost_Charge_BlockFields>::integer_value()); }
   private:
    friend class EnumBase<UtilityCost_Charge_BlockFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ UtilityCost_Charge_BlockFields::UtilityCostChargeBlockName, "UtilityCostChargeBlockName", "Utility Cost Charge Block Name"},
{ UtilityCost_Charge_BlockFields::TariffName, "TariffName", "Tariff Name"},
{ UtilityCost_Charge_BlockFields::SourceVariable, "SourceVariable", "Source Variable"},
{ UtilityCost_Charge_BlockFields::Season, "Season", "Season"},
{ UtilityCost_Charge_BlockFields::CategoryVariableName, "CategoryVariableName", "Category Variable Name"},
{ UtilityCost_Charge_BlockFields::RemainingIntoVariable, "RemainingIntoVariable", "Remaining Into Variable"},
{ UtilityCost_Charge_BlockFields::BlockSizeMultiplierValueorVariableName, "BlockSizeMultiplierValueorVariableName", "Block Size Multiplier Value or Variable Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const UtilityCost_Charge_BlockFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<UtilityCost_Charge_BlockFields> OptionalUtilityCost_Charge_BlockFields ;
#endif

/** \class UtilityCost_Charge_BlockExtensibleFields
 *  \brief Enumeration of UtilityCost:Charge:Block's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(UtilityCost_Charge_BlockExtensibleFields, )
#else
class UtilityCost_Charge_BlockExtensibleFields: public ::EnumBase<UtilityCost_Charge_BlockExtensibleFields> {
 public: 
  enum domain 
  {
BlockSizeValueorVariableName, BlockCostperUnitValueorVariableName,   };
  UtilityCost_Charge_BlockExtensibleFields()
   : EnumBase<UtilityCost_Charge_BlockExtensibleFields>(BlockSizeValueorVariableName) {} 
  UtilityCost_Charge_BlockExtensibleFields(const std::string &t_name) 
   : EnumBase<UtilityCost_Charge_BlockExtensibleFields>(t_name) {} 
  UtilityCost_Charge_BlockExtensibleFields(int t_value) 
   : EnumBase<UtilityCost_Charge_BlockExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "UtilityCost_Charge_BlockExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<UtilityCost_Charge_BlockExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<UtilityCost_Charge_BlockExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ UtilityCost_Charge_BlockExtensibleFields::BlockSizeValueorVariableName, "BlockSizeValueorVariableName", "Block Size Value or Variable Name"},
{ UtilityCost_Charge_BlockExtensibleFields::BlockCostperUnitValueorVariableName, "BlockCostperUnitValueorVariableName", "Block Cost per Unit Value or Variable Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const UtilityCost_Charge_BlockExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<UtilityCost_Charge_BlockExtensibleFields> OptionalUtilityCost_Charge_BlockExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_UTILITYCOST_CHARGE_BLOCK_FIELDENUMS_HXX
