/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_WINDOWMATERIAL_GLAZINGGROUP_THERMOCHROMIC_FIELDENUMS_HXX
#define UTILITIES_IDD_WINDOWMATERIAL_GLAZINGGROUP_THERMOCHROMIC_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class WindowMaterial_GlazingGroup_ThermochromicFields
 *  \brief Enumeration of WindowMaterial:GlazingGroup:Thermochromic's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(WindowMaterial_GlazingGroup_ThermochromicFields, )
#else
class WindowMaterial_GlazingGroup_ThermochromicFields: public ::EnumBase<WindowMaterial_GlazingGroup_ThermochromicFields> {
 public: 
  enum domain 
  {
Name,   };
  WindowMaterial_GlazingGroup_ThermochromicFields()
   : EnumBase<WindowMaterial_GlazingGroup_ThermochromicFields>(Name) {} 
  WindowMaterial_GlazingGroup_ThermochromicFields(const std::string &t_name) 
   : EnumBase<WindowMaterial_GlazingGroup_ThermochromicFields>(t_name) {} 
  WindowMaterial_GlazingGroup_ThermochromicFields(int t_value) 
   : EnumBase<WindowMaterial_GlazingGroup_ThermochromicFields>(t_value) {} 
  static std::string enumName() 
  { return "WindowMaterial_GlazingGroup_ThermochromicFields"; }
  domain value() const { return static_cast<domain>(EnumBase<WindowMaterial_GlazingGroup_ThermochromicFields>::integer_value()); }
   private:
    friend class EnumBase<WindowMaterial_GlazingGroup_ThermochromicFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ WindowMaterial_GlazingGroup_ThermochromicFields::Name, "Name", "Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const WindowMaterial_GlazingGroup_ThermochromicFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<WindowMaterial_GlazingGroup_ThermochromicFields> OptionalWindowMaterial_GlazingGroup_ThermochromicFields ;
#endif

/** \class WindowMaterial_GlazingGroup_ThermochromicExtensibleFields
 *  \brief Enumeration of WindowMaterial:GlazingGroup:Thermochromic's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(WindowMaterial_GlazingGroup_ThermochromicExtensibleFields, )
#else
class WindowMaterial_GlazingGroup_ThermochromicExtensibleFields: public ::EnumBase<WindowMaterial_GlazingGroup_ThermochromicExtensibleFields> {
 public: 
  enum domain 
  {
OpticalDataTemperature, WindowMaterialGlazingName,   };
  WindowMaterial_GlazingGroup_ThermochromicExtensibleFields()
   : EnumBase<WindowMaterial_GlazingGroup_ThermochromicExtensibleFields>(OpticalDataTemperature) {} 
  WindowMaterial_GlazingGroup_ThermochromicExtensibleFields(const std::string &t_name) 
   : EnumBase<WindowMaterial_GlazingGroup_ThermochromicExtensibleFields>(t_name) {} 
  WindowMaterial_GlazingGroup_ThermochromicExtensibleFields(int t_value) 
   : EnumBase<WindowMaterial_GlazingGroup_ThermochromicExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "WindowMaterial_GlazingGroup_ThermochromicExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<WindowMaterial_GlazingGroup_ThermochromicExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<WindowMaterial_GlazingGroup_ThermochromicExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ WindowMaterial_GlazingGroup_ThermochromicExtensibleFields::OpticalDataTemperature, "OpticalDataTemperature", "Optical Data Temperature"},
{ WindowMaterial_GlazingGroup_ThermochromicExtensibleFields::WindowMaterialGlazingName, "WindowMaterialGlazingName", "Window Material Glazing Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const WindowMaterial_GlazingGroup_ThermochromicExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<WindowMaterial_GlazingGroup_ThermochromicExtensibleFields> OptionalWindowMaterial_GlazingGroup_ThermochromicExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_WINDOWMATERIAL_GLAZINGGROUP_THERMOCHROMIC_FIELDENUMS_HXX
