/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AVAILABILITYMANAGER_LOWTEMPERATURETURNON_FIELDENUMS_HXX
#define UTILITIES_IDD_AVAILABILITYMANAGER_LOWTEMPERATURETURNON_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AvailabilityManager_LowTemperatureTurnOnFields
 *  \brief Enumeration of AvailabilityManager:LowTemperatureTurnOn's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AvailabilityManager_LowTemperatureTurnOnFields, )
#else
class AvailabilityManager_LowTemperatureTurnOnFields: public ::EnumBase<AvailabilityManager_LowTemperatureTurnOnFields> {
 public: 
  enum domain 
  {
Name, SensorNodeName, Temperature,   };
  AvailabilityManager_LowTemperatureTurnOnFields()
   : EnumBase<AvailabilityManager_LowTemperatureTurnOnFields>(Name) {} 
  AvailabilityManager_LowTemperatureTurnOnFields(const std::string &t_name) 
   : EnumBase<AvailabilityManager_LowTemperatureTurnOnFields>(t_name) {} 
  AvailabilityManager_LowTemperatureTurnOnFields(int t_value) 
   : EnumBase<AvailabilityManager_LowTemperatureTurnOnFields>(t_value) {} 
  static std::string enumName() 
  { return "AvailabilityManager_LowTemperatureTurnOnFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AvailabilityManager_LowTemperatureTurnOnFields>::integer_value()); }
   private:
    friend class EnumBase<AvailabilityManager_LowTemperatureTurnOnFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AvailabilityManager_LowTemperatureTurnOnFields::Name, "Name", "Name"},
{ AvailabilityManager_LowTemperatureTurnOnFields::SensorNodeName, "SensorNodeName", "Sensor Node Name"},
{ AvailabilityManager_LowTemperatureTurnOnFields::Temperature, "Temperature", "Temperature"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AvailabilityManager_LowTemperatureTurnOnFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AvailabilityManager_LowTemperatureTurnOnFields> OptionalAvailabilityManager_LowTemperatureTurnOnFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AVAILABILITYMANAGER_LOWTEMPERATURETURNON_FIELDENUMS_HXX
