/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_COIL_DX_ASHRAE205_PERFORMANCE_FIELDENUMS_HXX
#define UTILITIES_IDD_COIL_DX_ASHRAE205_PERFORMANCE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Coil_DX_ASHRAE205_PerformanceFields
 *  \brief Enumeration of Coil:DX:ASHRAE205:Performance's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Coil_DX_ASHRAE205_PerformanceFields, )
#else
class Coil_DX_ASHRAE205_PerformanceFields: public ::EnumBase<Coil_DX_ASHRAE205_PerformanceFields> {
 public: 
  enum domain 
  {
Name, RepresentationFileName, PerformanceInterpolationMethod, RatedTotalCoolingCapacity, RatedSteadyStateHeatingCapacity,   };
  Coil_DX_ASHRAE205_PerformanceFields()
   : EnumBase<Coil_DX_ASHRAE205_PerformanceFields>(Name) {} 
  Coil_DX_ASHRAE205_PerformanceFields(const std::string &t_name) 
   : EnumBase<Coil_DX_ASHRAE205_PerformanceFields>(t_name) {} 
  Coil_DX_ASHRAE205_PerformanceFields(int t_value) 
   : EnumBase<Coil_DX_ASHRAE205_PerformanceFields>(t_value) {} 
  static std::string enumName() 
  { return "Coil_DX_ASHRAE205_PerformanceFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Coil_DX_ASHRAE205_PerformanceFields>::integer_value()); }
   private:
    friend class EnumBase<Coil_DX_ASHRAE205_PerformanceFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Coil_DX_ASHRAE205_PerformanceFields::Name, "Name", "Name"},
{ Coil_DX_ASHRAE205_PerformanceFields::RepresentationFileName, "RepresentationFileName", "Representation File Name"},
{ Coil_DX_ASHRAE205_PerformanceFields::PerformanceInterpolationMethod, "PerformanceInterpolationMethod", "Performance Interpolation Method"},
{ Coil_DX_ASHRAE205_PerformanceFields::RatedTotalCoolingCapacity, "RatedTotalCoolingCapacity", "Rated Total Cooling Capacity"},
{ Coil_DX_ASHRAE205_PerformanceFields::RatedSteadyStateHeatingCapacity, "RatedSteadyStateHeatingCapacity", "Rated Steady-State Heating Capacity"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Coil_DX_ASHRAE205_PerformanceFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Coil_DX_ASHRAE205_PerformanceFields> OptionalCoil_DX_ASHRAE205_PerformanceFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_COIL_DX_ASHRAE205_PERFORMANCE_FIELDENUMS_HXX
