/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_ENERGYMANAGEMENTSYSTEM_CURVEORTABLEINDEXVARIABLE_FIELDENUMS_HXX
#define UTILITIES_IDD_ENERGYMANAGEMENTSYSTEM_CURVEORTABLEINDEXVARIABLE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class EnergyManagementSystem_CurveOrTableIndexVariableFields
 *  \brief Enumeration of EnergyManagementSystem:CurveOrTableIndexVariable's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(EnergyManagementSystem_CurveOrTableIndexVariableFields, )
#else
class EnergyManagementSystem_CurveOrTableIndexVariableFields: public ::EnumBase<EnergyManagementSystem_CurveOrTableIndexVariableFields> {
 public: 
  enum domain 
  {
Name, CurveorTableObjectName,   };
  EnergyManagementSystem_CurveOrTableIndexVariableFields()
   : EnumBase<EnergyManagementSystem_CurveOrTableIndexVariableFields>(Name) {} 
  EnergyManagementSystem_CurveOrTableIndexVariableFields(const std::string &t_name) 
   : EnumBase<EnergyManagementSystem_CurveOrTableIndexVariableFields>(t_name) {} 
  EnergyManagementSystem_CurveOrTableIndexVariableFields(int t_value) 
   : EnumBase<EnergyManagementSystem_CurveOrTableIndexVariableFields>(t_value) {} 
  static std::string enumName() 
  { return "EnergyManagementSystem_CurveOrTableIndexVariableFields"; }
  domain value() const { return static_cast<domain>(EnumBase<EnergyManagementSystem_CurveOrTableIndexVariableFields>::integer_value()); }
   private:
    friend class EnumBase<EnergyManagementSystem_CurveOrTableIndexVariableFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ EnergyManagementSystem_CurveOrTableIndexVariableFields::Name, "Name", "Name"},
{ EnergyManagementSystem_CurveOrTableIndexVariableFields::CurveorTableObjectName, "CurveorTableObjectName", "Curve or Table Object Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const EnergyManagementSystem_CurveOrTableIndexVariableFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<EnergyManagementSystem_CurveOrTableIndexVariableFields> OptionalEnergyManagementSystem_CurveOrTableIndexVariableFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_ENERGYMANAGEMENTSYSTEM_CURVEORTABLEINDEXVARIABLE_FIELDENUMS_HXX
