/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_EXTERNALINTERFACE_FUNCTIONALMOCKUPUNITEXPORT_TO_VARIABLE_FIELDENUMS_HXX
#define UTILITIES_IDD_EXTERNALINTERFACE_FUNCTIONALMOCKUPUNITEXPORT_TO_VARIABLE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ExternalInterface_FunctionalMockupUnitExport_To_VariableFields
 *  \brief Enumeration of ExternalInterface:FunctionalMockupUnitExport:To:Variable's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ExternalInterface_FunctionalMockupUnitExport_To_VariableFields, )
#else
class ExternalInterface_FunctionalMockupUnitExport_To_VariableFields: public ::EnumBase<ExternalInterface_FunctionalMockupUnitExport_To_VariableFields> {
 public: 
  enum domain 
  {
Name, FMUVariableName, InitialValue,   };
  ExternalInterface_FunctionalMockupUnitExport_To_VariableFields()
   : EnumBase<ExternalInterface_FunctionalMockupUnitExport_To_VariableFields>(Name) {} 
  ExternalInterface_FunctionalMockupUnitExport_To_VariableFields(const std::string &t_name) 
   : EnumBase<ExternalInterface_FunctionalMockupUnitExport_To_VariableFields>(t_name) {} 
  ExternalInterface_FunctionalMockupUnitExport_To_VariableFields(int t_value) 
   : EnumBase<ExternalInterface_FunctionalMockupUnitExport_To_VariableFields>(t_value) {} 
  static std::string enumName() 
  { return "ExternalInterface_FunctionalMockupUnitExport_To_VariableFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ExternalInterface_FunctionalMockupUnitExport_To_VariableFields>::integer_value()); }
   private:
    friend class EnumBase<ExternalInterface_FunctionalMockupUnitExport_To_VariableFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ExternalInterface_FunctionalMockupUnitExport_To_VariableFields::Name, "Name", "Name"},
{ ExternalInterface_FunctionalMockupUnitExport_To_VariableFields::FMUVariableName, "FMUVariableName", "FMU Variable Name"},
{ ExternalInterface_FunctionalMockupUnitExport_To_VariableFields::InitialValue, "InitialValue", "Initial Value"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ExternalInterface_FunctionalMockupUnitExport_To_VariableFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ExternalInterface_FunctionalMockupUnitExport_To_VariableFields> OptionalExternalInterface_FunctionalMockupUnitExport_To_VariableFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_EXTERNALINTERFACE_FUNCTIONALMOCKUPUNITEXPORT_TO_VARIABLE_FIELDENUMS_HXX
