/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_GROUNDHEATEXCHANGER_VERTICAL_SIZING_RECTANGLE_FIELDENUMS_HXX
#define UTILITIES_IDD_GROUNDHEATEXCHANGER_VERTICAL_SIZING_RECTANGLE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class GroundHeatExchanger_Vertical_Sizing_RectangleFields
 *  \brief Enumeration of GroundHeatExchanger:Vertical:Sizing:Rectangle's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(GroundHeatExchanger_Vertical_Sizing_RectangleFields, )
#else
class GroundHeatExchanger_Vertical_Sizing_RectangleFields: public ::EnumBase<GroundHeatExchanger_Vertical_Sizing_RectangleFields> {
 public: 
  enum domain 
  {
Name, SizingPeriod_WeatherFileDaysName, DesignFlowRatePerBorehole, AvailableBoreholeFieldLength, AvailableBoreholeFieldWidth, MaximumNumberofBoreholes, MinimumBoreholeSpacing, MaximumBoreholeSpacing, MinimumBoreholeVerticalLength, MaximumBoreholeVerticalLength, MinimumExitingFluidTemperatureforSizing, MaximumExitingFluidTemperatureforSizing,   };
  GroundHeatExchanger_Vertical_Sizing_RectangleFields()
   : EnumBase<GroundHeatExchanger_Vertical_Sizing_RectangleFields>(Name) {} 
  GroundHeatExchanger_Vertical_Sizing_RectangleFields(const std::string &t_name) 
   : EnumBase<GroundHeatExchanger_Vertical_Sizing_RectangleFields>(t_name) {} 
  GroundHeatExchanger_Vertical_Sizing_RectangleFields(int t_value) 
   : EnumBase<GroundHeatExchanger_Vertical_Sizing_RectangleFields>(t_value) {} 
  static std::string enumName() 
  { return "GroundHeatExchanger_Vertical_Sizing_RectangleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<GroundHeatExchanger_Vertical_Sizing_RectangleFields>::integer_value()); }
   private:
    friend class EnumBase<GroundHeatExchanger_Vertical_Sizing_RectangleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::Name, "Name", "Name"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::SizingPeriod_WeatherFileDaysName, "SizingPeriod_WeatherFileDaysName", "SizingPeriod:WeatherFileDays Name"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::DesignFlowRatePerBorehole, "DesignFlowRatePerBorehole", "Design Flow Rate Per Borehole"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::AvailableBoreholeFieldLength, "AvailableBoreholeFieldLength", "Available Borehole Field Length"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::AvailableBoreholeFieldWidth, "AvailableBoreholeFieldWidth", "Available Borehole Field Width"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::MaximumNumberofBoreholes, "MaximumNumberofBoreholes", "Maximum Number of Boreholes"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::MinimumBoreholeSpacing, "MinimumBoreholeSpacing", "Minimum Borehole Spacing"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::MaximumBoreholeSpacing, "MaximumBoreholeSpacing", "Maximum Borehole Spacing"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::MinimumBoreholeVerticalLength, "MinimumBoreholeVerticalLength", "Minimum Borehole Vertical Length"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::MaximumBoreholeVerticalLength, "MaximumBoreholeVerticalLength", "Maximum Borehole Vertical Length"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::MinimumExitingFluidTemperatureforSizing, "MinimumExitingFluidTemperatureforSizing", "Minimum Exiting Fluid Temperature for Sizing"},
{ GroundHeatExchanger_Vertical_Sizing_RectangleFields::MaximumExitingFluidTemperatureforSizing, "MaximumExitingFluidTemperatureforSizing", "Maximum Exiting Fluid Temperature for Sizing"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const GroundHeatExchanger_Vertical_Sizing_RectangleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<GroundHeatExchanger_Vertical_Sizing_RectangleFields> OptionalGroundHeatExchanger_Vertical_Sizing_RectangleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_GROUNDHEATEXCHANGER_VERTICAL_SIZING_RECTANGLE_FIELDENUMS_HXX
