/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_ENERGYMANAGEMENTSYSTEM_ACTUATOR_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_ENERGYMANAGEMENTSYSTEM_ACTUATOR_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_EnergyManagementSystem_ActuatorFields
 *  \brief Enumeration of OS:EnergyManagementSystem:Actuator's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_EnergyManagementSystem_ActuatorFields, )
#else
class OS_EnergyManagementSystem_ActuatorFields: public ::EnumBase<OS_EnergyManagementSystem_ActuatorFields> {
 public: 
  enum domain 
  {
Handle, Name, ActuatedComponentName, ActuatedComponentType, ActuatedComponentControlType, ZoneorSpaceName,   };
  OS_EnergyManagementSystem_ActuatorFields()
   : EnumBase<OS_EnergyManagementSystem_ActuatorFields>(Handle) {} 
  OS_EnergyManagementSystem_ActuatorFields(const std::string &t_name) 
   : EnumBase<OS_EnergyManagementSystem_ActuatorFields>(t_name) {} 
  OS_EnergyManagementSystem_ActuatorFields(int t_value) 
   : EnumBase<OS_EnergyManagementSystem_ActuatorFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_EnergyManagementSystem_ActuatorFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_EnergyManagementSystem_ActuatorFields>::integer_value()); }
   private:
    friend class EnumBase<OS_EnergyManagementSystem_ActuatorFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_EnergyManagementSystem_ActuatorFields::Handle, "Handle", "Handle"},
{ OS_EnergyManagementSystem_ActuatorFields::Name, "Name", "Name"},
{ OS_EnergyManagementSystem_ActuatorFields::ActuatedComponentName, "ActuatedComponentName", "Actuated Component Name"},
{ OS_EnergyManagementSystem_ActuatorFields::ActuatedComponentType, "ActuatedComponentType", "Actuated Component Type"},
{ OS_EnergyManagementSystem_ActuatorFields::ActuatedComponentControlType, "ActuatedComponentControlType", "Actuated Component Control Type"},
{ OS_EnergyManagementSystem_ActuatorFields::ZoneorSpaceName, "ZoneorSpaceName", "Zone or Space Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_EnergyManagementSystem_ActuatorFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_EnergyManagementSystem_ActuatorFields> OptionalOS_EnergyManagementSystem_ActuatorFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_ENERGYMANAGEMENTSYSTEM_ACTUATOR_FIELDENUMS_HXX
