/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_HEATING_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_HEATING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_HeatPump_AirToWater_HeatingFields
 *  \brief Enumeration of OS:HeatPump:AirToWater:Heating's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_HeatPump_AirToWater_HeatingFields, )
#else
class OS_HeatPump_AirToWater_HeatingFields: public ::EnumBase<OS_HeatPump_AirToWater_HeatingFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilityScheduleName, RatedInletAirTemperature, RatedAirFlowRate, RatedLeavingWaterTemperature, RatedWaterFlowRate, MinimumOutdoorAirTemperature, MaximumOutdoorAirTemperature, MinimumLeavingWaterTemperatureCurveName, MaximumLeavingWaterTemperatureCurveName, SizingFactor, HotWaterInletNodeName, HotWaterOutletNodeName, SpeedDataList, BoosterModeOnSpeed,   };
  OS_HeatPump_AirToWater_HeatingFields()
   : EnumBase<OS_HeatPump_AirToWater_HeatingFields>(Handle) {} 
  OS_HeatPump_AirToWater_HeatingFields(const std::string &t_name) 
   : EnumBase<OS_HeatPump_AirToWater_HeatingFields>(t_name) {} 
  OS_HeatPump_AirToWater_HeatingFields(int t_value) 
   : EnumBase<OS_HeatPump_AirToWater_HeatingFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_HeatPump_AirToWater_HeatingFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_HeatPump_AirToWater_HeatingFields>::integer_value()); }
   private:
    friend class EnumBase<OS_HeatPump_AirToWater_HeatingFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_HeatPump_AirToWater_HeatingFields::Handle, "Handle", "Handle"},
{ OS_HeatPump_AirToWater_HeatingFields::Name, "Name", "Name"},
{ OS_HeatPump_AirToWater_HeatingFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ OS_HeatPump_AirToWater_HeatingFields::RatedInletAirTemperature, "RatedInletAirTemperature", "Rated Inlet Air Temperature"},
{ OS_HeatPump_AirToWater_HeatingFields::RatedAirFlowRate, "RatedAirFlowRate", "Rated Air Flow Rate"},
{ OS_HeatPump_AirToWater_HeatingFields::RatedLeavingWaterTemperature, "RatedLeavingWaterTemperature", "Rated Leaving Water Temperature"},
{ OS_HeatPump_AirToWater_HeatingFields::RatedWaterFlowRate, "RatedWaterFlowRate", "Rated Water Flow Rate"},
{ OS_HeatPump_AirToWater_HeatingFields::MinimumOutdoorAirTemperature, "MinimumOutdoorAirTemperature", "Minimum Outdoor Air Temperature"},
{ OS_HeatPump_AirToWater_HeatingFields::MaximumOutdoorAirTemperature, "MaximumOutdoorAirTemperature", "Maximum Outdoor Air Temperature"},
{ OS_HeatPump_AirToWater_HeatingFields::MinimumLeavingWaterTemperatureCurveName, "MinimumLeavingWaterTemperatureCurveName", "Minimum Leaving Water Temperature Curve Name"},
{ OS_HeatPump_AirToWater_HeatingFields::MaximumLeavingWaterTemperatureCurveName, "MaximumLeavingWaterTemperatureCurveName", "Maximum Leaving Water Temperature Curve Name"},
{ OS_HeatPump_AirToWater_HeatingFields::SizingFactor, "SizingFactor", "Sizing Factor"},
{ OS_HeatPump_AirToWater_HeatingFields::HotWaterInletNodeName, "HotWaterInletNodeName", "Hot Water Inlet Node Name"},
{ OS_HeatPump_AirToWater_HeatingFields::HotWaterOutletNodeName, "HotWaterOutletNodeName", "Hot Water Outlet Node Name"},
{ OS_HeatPump_AirToWater_HeatingFields::SpeedDataList, "SpeedDataList", "Speed Data List"},
{ OS_HeatPump_AirToWater_HeatingFields::BoosterModeOnSpeed, "BoosterModeOnSpeed", "Booster Mode On Speed"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_HeatPump_AirToWater_HeatingFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_HeatPump_AirToWater_HeatingFields> OptionalOS_HeatPump_AirToWater_HeatingFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_HEATPUMP_AIRTOWATER_HEATING_FIELDENUMS_HXX
