/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_OTHEREQUIPMENT_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_OTHEREQUIPMENT_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_OtherEquipmentFields
 *  \brief Enumeration of OS:OtherEquipment's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_OtherEquipmentFields, )
#else
class OS_OtherEquipmentFields: public ::EnumBase<OS_OtherEquipmentFields> {
 public: 
  enum domain 
  {
Handle, Name, OtherEquipmentDefinitionName, SpaceorSpaceTypeName, ScheduleName, Multiplier, FuelType, EndUseSubcategory,   };
  OS_OtherEquipmentFields()
   : EnumBase<OS_OtherEquipmentFields>(Handle) {} 
  OS_OtherEquipmentFields(const std::string &t_name) 
   : EnumBase<OS_OtherEquipmentFields>(t_name) {} 
  OS_OtherEquipmentFields(int t_value) 
   : EnumBase<OS_OtherEquipmentFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_OtherEquipmentFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_OtherEquipmentFields>::integer_value()); }
   private:
    friend class EnumBase<OS_OtherEquipmentFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_OtherEquipmentFields::Handle, "Handle", "Handle"},
{ OS_OtherEquipmentFields::Name, "Name", "Name"},
{ OS_OtherEquipmentFields::OtherEquipmentDefinitionName, "OtherEquipmentDefinitionName", "Other Equipment Definition Name"},
{ OS_OtherEquipmentFields::SpaceorSpaceTypeName, "SpaceorSpaceTypeName", "Space or SpaceType Name"},
{ OS_OtherEquipmentFields::ScheduleName, "ScheduleName", "Schedule Name"},
{ OS_OtherEquipmentFields::Multiplier, "Multiplier", "Multiplier"},
{ OS_OtherEquipmentFields::FuelType, "FuelType", "Fuel Type"},
{ OS_OtherEquipmentFields::EndUseSubcategory, "EndUseSubcategory", "End-Use Subcategory"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_OtherEquipmentFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_OtherEquipmentFields> OptionalOS_OtherEquipmentFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_OTHEREQUIPMENT_FIELDENUMS_HXX
