/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SETPOINTMANAGER_OUTDOORAIRPRETREAT_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SETPOINTMANAGER_OUTDOORAIRPRETREAT_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SetpointManager_OutdoorAirPretreatFields
 *  \brief Enumeration of OS:SetpointManager:OutdoorAirPretreat's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SetpointManager_OutdoorAirPretreatFields, )
#else
class OS_SetpointManager_OutdoorAirPretreatFields: public ::EnumBase<OS_SetpointManager_OutdoorAirPretreatFields> {
 public: 
  enum domain 
  {
Handle, Name, ControlVariable, MinimumSetpointTemperature, MaximumSetpointTemperature, MinimumSetpointHumidityRatio, MaximumSetpointHumidityRatio, ReferenceSetpointNodeName, MixedAirStreamNodeName, OutdoorAirStreamNodeName, ReturnAirStreamNodeName, SetpointNodeorNodeListName,   };
  OS_SetpointManager_OutdoorAirPretreatFields()
   : EnumBase<OS_SetpointManager_OutdoorAirPretreatFields>(Handle) {} 
  OS_SetpointManager_OutdoorAirPretreatFields(const std::string &t_name) 
   : EnumBase<OS_SetpointManager_OutdoorAirPretreatFields>(t_name) {} 
  OS_SetpointManager_OutdoorAirPretreatFields(int t_value) 
   : EnumBase<OS_SetpointManager_OutdoorAirPretreatFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SetpointManager_OutdoorAirPretreatFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SetpointManager_OutdoorAirPretreatFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SetpointManager_OutdoorAirPretreatFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SetpointManager_OutdoorAirPretreatFields::Handle, "Handle", "Handle"},
{ OS_SetpointManager_OutdoorAirPretreatFields::Name, "Name", "Name"},
{ OS_SetpointManager_OutdoorAirPretreatFields::ControlVariable, "ControlVariable", "Control Variable"},
{ OS_SetpointManager_OutdoorAirPretreatFields::MinimumSetpointTemperature, "MinimumSetpointTemperature", "Minimum Setpoint Temperature"},
{ OS_SetpointManager_OutdoorAirPretreatFields::MaximumSetpointTemperature, "MaximumSetpointTemperature", "Maximum Setpoint Temperature"},
{ OS_SetpointManager_OutdoorAirPretreatFields::MinimumSetpointHumidityRatio, "MinimumSetpointHumidityRatio", "Minimum Setpoint Humidity Ratio"},
{ OS_SetpointManager_OutdoorAirPretreatFields::MaximumSetpointHumidityRatio, "MaximumSetpointHumidityRatio", "Maximum Setpoint Humidity Ratio"},
{ OS_SetpointManager_OutdoorAirPretreatFields::ReferenceSetpointNodeName, "ReferenceSetpointNodeName", "Reference Setpoint Node Name"},
{ OS_SetpointManager_OutdoorAirPretreatFields::MixedAirStreamNodeName, "MixedAirStreamNodeName", "Mixed Air Stream Node Name"},
{ OS_SetpointManager_OutdoorAirPretreatFields::OutdoorAirStreamNodeName, "OutdoorAirStreamNodeName", "Outdoor Air Stream Node Name"},
{ OS_SetpointManager_OutdoorAirPretreatFields::ReturnAirStreamNodeName, "ReturnAirStreamNodeName", "Return Air Stream Node Name"},
{ OS_SetpointManager_OutdoorAirPretreatFields::SetpointNodeorNodeListName, "SetpointNodeorNodeListName", "Setpoint Node or NodeList Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SetpointManager_OutdoorAirPretreatFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SetpointManager_OutdoorAirPretreatFields> OptionalOS_SetpointManager_OutdoorAirPretreatFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SETPOINTMANAGER_OUTDOORAIRPRETREAT_FIELDENUMS_HXX
