/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OUTPUT_CONSTRUCTIONS_FIELDENUMS_HXX
#define UTILITIES_IDD_OUTPUT_CONSTRUCTIONS_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Output_ConstructionsFields
 *  \brief Enumeration of Output:Constructions's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Output_ConstructionsFields, )
#else
class Output_ConstructionsFields: public ::EnumBase<Output_ConstructionsFields> {
 public: 
  enum domain 
  {
DetailsType1, DetailsType2,   };
  Output_ConstructionsFields()
   : EnumBase<Output_ConstructionsFields>(DetailsType1) {} 
  Output_ConstructionsFields(const std::string &t_name) 
   : EnumBase<Output_ConstructionsFields>(t_name) {} 
  Output_ConstructionsFields(int t_value) 
   : EnumBase<Output_ConstructionsFields>(t_value) {} 
  static std::string enumName() 
  { return "Output_ConstructionsFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Output_ConstructionsFields>::integer_value()); }
   private:
    friend class EnumBase<Output_ConstructionsFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Output_ConstructionsFields::DetailsType1, "DetailsType1", "Details Type 1"},
{ Output_ConstructionsFields::DetailsType2, "DetailsType2", "Details Type 2"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Output_ConstructionsFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Output_ConstructionsFields> OptionalOutput_ConstructionsFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OUTPUT_CONSTRUCTIONS_FIELDENUMS_HXX
