/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_ROOMAIR_TEMPERATUREPATTERN_CONSTANTGRADIENT_FIELDENUMS_HXX
#define UTILITIES_IDD_ROOMAIR_TEMPERATUREPATTERN_CONSTANTGRADIENT_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class RoomAir_TemperaturePattern_ConstantGradientFields
 *  \brief Enumeration of RoomAir:TemperaturePattern:ConstantGradient's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(RoomAir_TemperaturePattern_ConstantGradientFields, )
#else
class RoomAir_TemperaturePattern_ConstantGradientFields: public ::EnumBase<RoomAir_TemperaturePattern_ConstantGradientFields> {
 public: 
  enum domain 
  {
RoomAirTemperaturePatternConstantGradientName, ControlIntegerforPatternControlScheduleName, ThermostatOffset, ReturnAirOffset, ExhaustAirOffset, TemperatureGradient,   };
  RoomAir_TemperaturePattern_ConstantGradientFields()
   : EnumBase<RoomAir_TemperaturePattern_ConstantGradientFields>(RoomAirTemperaturePatternConstantGradientName) {} 
  RoomAir_TemperaturePattern_ConstantGradientFields(const std::string &t_name) 
   : EnumBase<RoomAir_TemperaturePattern_ConstantGradientFields>(t_name) {} 
  RoomAir_TemperaturePattern_ConstantGradientFields(int t_value) 
   : EnumBase<RoomAir_TemperaturePattern_ConstantGradientFields>(t_value) {} 
  static std::string enumName() 
  { return "RoomAir_TemperaturePattern_ConstantGradientFields"; }
  domain value() const { return static_cast<domain>(EnumBase<RoomAir_TemperaturePattern_ConstantGradientFields>::integer_value()); }
   private:
    friend class EnumBase<RoomAir_TemperaturePattern_ConstantGradientFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ RoomAir_TemperaturePattern_ConstantGradientFields::RoomAirTemperaturePatternConstantGradientName, "RoomAirTemperaturePatternConstantGradientName", "Room Air Temperature Pattern Constant Gradient Name"},
{ RoomAir_TemperaturePattern_ConstantGradientFields::ControlIntegerforPatternControlScheduleName, "ControlIntegerforPatternControlScheduleName", "Control Integer for Pattern Control Schedule Name"},
{ RoomAir_TemperaturePattern_ConstantGradientFields::ThermostatOffset, "ThermostatOffset", "Thermostat Offset"},
{ RoomAir_TemperaturePattern_ConstantGradientFields::ReturnAirOffset, "ReturnAirOffset", "Return Air Offset"},
{ RoomAir_TemperaturePattern_ConstantGradientFields::ExhaustAirOffset, "ExhaustAirOffset", "Exhaust Air Offset"},
{ RoomAir_TemperaturePattern_ConstantGradientFields::TemperatureGradient, "TemperatureGradient", "Temperature Gradient"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const RoomAir_TemperaturePattern_ConstantGradientFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<RoomAir_TemperaturePattern_ConstantGradientFields> OptionalRoomAir_TemperaturePattern_ConstantGradientFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_ROOMAIR_TEMPERATUREPATTERN_CONSTANTGRADIENT_FIELDENUMS_HXX
