/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_EXTERNALINTERFACE_FUNCTIONALMOCKUPUNITIMPORT_TO_ACTUATOR_FIELDENUMS_HXX
#define UTILITIES_IDD_EXTERNALINTERFACE_FUNCTIONALMOCKUPUNITIMPORT_TO_ACTUATOR_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields
 *  \brief Enumeration of ExternalInterface:FunctionalMockupUnitImport:To:Actuator's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields, )
#else
class ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields: public ::EnumBase<ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields> {
 public: 
  enum domain 
  {
Name, ActuatedComponentUniqueName, ActuatedComponentType, ActuatedComponentControlType, FMUFileName, FMUInstanceName, FMUVariableName, InitialValue,   };
  ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields()
   : EnumBase<ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields>(Name) {} 
  ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields(const std::string &t_name) 
   : EnumBase<ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields>(t_name) {} 
  ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields(int t_value) 
   : EnumBase<ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields>(t_value) {} 
  static std::string enumName() 
  { return "ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields>::integer_value()); }
   private:
    friend class EnumBase<ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::Name, "Name", "Name"},
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::ActuatedComponentUniqueName, "ActuatedComponentUniqueName", "Actuated Component Unique Name"},
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::ActuatedComponentType, "ActuatedComponentType", "Actuated Component Type"},
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::ActuatedComponentControlType, "ActuatedComponentControlType", "Actuated Component Control Type"},
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::FMUFileName, "FMUFileName", "FMU File Name"},
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::FMUInstanceName, "FMUInstanceName", "FMU Instance Name"},
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::FMUVariableName, "FMUVariableName", "FMU Variable Name"},
{ ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields::InitialValue, "InitialValue", "Initial Value"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields> OptionalExternalInterface_FunctionalMockupUnitImport_To_ActuatorFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_EXTERNALINTERFACE_FUNCTIONALMOCKUPUNITIMPORT_TO_ACTUATOR_FIELDENUMS_HXX
