/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_ROOFIRRIGATION_FIELDENUMS_HXX
#define UTILITIES_IDD_ROOFIRRIGATION_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class RoofIrrigationFields
 *  \brief Enumeration of RoofIrrigation's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(RoofIrrigationFields, )
#else
class RoofIrrigationFields: public ::EnumBase<RoofIrrigationFields> {
 public: 
  enum domain 
  {
IrrigationModelType, IrrigationRateScheduleName, IrrigationMaximumSaturationThreshold,   };
  RoofIrrigationFields()
   : EnumBase<RoofIrrigationFields>(IrrigationModelType) {} 
  RoofIrrigationFields(const std::string &t_name) 
   : EnumBase<RoofIrrigationFields>(t_name) {} 
  RoofIrrigationFields(int t_value) 
   : EnumBase<RoofIrrigationFields>(t_value) {} 
  static std::string enumName() 
  { return "RoofIrrigationFields"; }
  domain value() const { return static_cast<domain>(EnumBase<RoofIrrigationFields>::integer_value()); }
   private:
    friend class EnumBase<RoofIrrigationFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ RoofIrrigationFields::IrrigationModelType, "IrrigationModelType", "Irrigation Model Type"},
{ RoofIrrigationFields::IrrigationRateScheduleName, "IrrigationRateScheduleName", "Irrigation Rate Schedule Name"},
{ RoofIrrigationFields::IrrigationMaximumSaturationThreshold, "IrrigationMaximumSaturationThreshold", "Irrigation Maximum Saturation Threshold"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const RoofIrrigationFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<RoofIrrigationFields> OptionalRoofIrrigationFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_ROOFIRRIGATION_FIELDENUMS_HXX
