/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_FAULTMODEL_ENTHALPYSENSOROFFSET_OUTDOORAIR_FIELDENUMS_HXX
#define UTILITIES_IDD_FAULTMODEL_ENTHALPYSENSOROFFSET_OUTDOORAIR_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class FaultModel_EnthalpySensorOffset_OutdoorAirFields
 *  \brief Enumeration of FaultModel:EnthalpySensorOffset:OutdoorAir's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(FaultModel_EnthalpySensorOffset_OutdoorAirFields, )
#else
class FaultModel_EnthalpySensorOffset_OutdoorAirFields: public ::EnumBase<FaultModel_EnthalpySensorOffset_OutdoorAirFields> {
 public: 
  enum domain 
  {
Name, AvailabilityScheduleName, SeverityScheduleName, ControllerObjectType, ControllerObjectName, EnthalpySensorOffset,   };
  FaultModel_EnthalpySensorOffset_OutdoorAirFields()
   : EnumBase<FaultModel_EnthalpySensorOffset_OutdoorAirFields>(Name) {} 
  FaultModel_EnthalpySensorOffset_OutdoorAirFields(const std::string &t_name) 
   : EnumBase<FaultModel_EnthalpySensorOffset_OutdoorAirFields>(t_name) {} 
  FaultModel_EnthalpySensorOffset_OutdoorAirFields(int t_value) 
   : EnumBase<FaultModel_EnthalpySensorOffset_OutdoorAirFields>(t_value) {} 
  static std::string enumName() 
  { return "FaultModel_EnthalpySensorOffset_OutdoorAirFields"; }
  domain value() const { return static_cast<domain>(EnumBase<FaultModel_EnthalpySensorOffset_OutdoorAirFields>::integer_value()); }
   private:
    friend class EnumBase<FaultModel_EnthalpySensorOffset_OutdoorAirFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ FaultModel_EnthalpySensorOffset_OutdoorAirFields::Name, "Name", "Name"},
{ FaultModel_EnthalpySensorOffset_OutdoorAirFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ FaultModel_EnthalpySensorOffset_OutdoorAirFields::SeverityScheduleName, "SeverityScheduleName", "Severity Schedule Name"},
{ FaultModel_EnthalpySensorOffset_OutdoorAirFields::ControllerObjectType, "ControllerObjectType", "Controller Object Type"},
{ FaultModel_EnthalpySensorOffset_OutdoorAirFields::ControllerObjectName, "ControllerObjectName", "Controller Object Name"},
{ FaultModel_EnthalpySensorOffset_OutdoorAirFields::EnthalpySensorOffset, "EnthalpySensorOffset", "Enthalpy Sensor Offset"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const FaultModel_EnthalpySensorOffset_OutdoorAirFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<FaultModel_EnthalpySensorOffset_OutdoorAirFields> OptionalFaultModel_EnthalpySensorOffset_OutdoorAirFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_FAULTMODEL_ENTHALPYSENSOROFFSET_OUTDOORAIR_FIELDENUMS_HXX
