/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_GROUNDHEATTRANSFER_BASEMENT_SIMPARAMETERS_FIELDENUMS_HXX
#define UTILITIES_IDD_GROUNDHEATTRANSFER_BASEMENT_SIMPARAMETERS_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class GroundHeatTransfer_Basement_SimParametersFields
 *  \brief Enumeration of GroundHeatTransfer:Basement:SimParameters's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(GroundHeatTransfer_Basement_SimParametersFields, )
#else
class GroundHeatTransfer_Basement_SimParametersFields: public ::EnumBase<GroundHeatTransfer_Basement_SimParametersFields> {
 public: 
  enum domain 
  {
F_MultiplierfortheADIsolution, IYRS_Maximumnumberofyearlyiterations_,   };
  GroundHeatTransfer_Basement_SimParametersFields()
   : EnumBase<GroundHeatTransfer_Basement_SimParametersFields>(F_MultiplierfortheADIsolution) {} 
  GroundHeatTransfer_Basement_SimParametersFields(const std::string &t_name) 
   : EnumBase<GroundHeatTransfer_Basement_SimParametersFields>(t_name) {} 
  GroundHeatTransfer_Basement_SimParametersFields(int t_value) 
   : EnumBase<GroundHeatTransfer_Basement_SimParametersFields>(t_value) {} 
  static std::string enumName() 
  { return "GroundHeatTransfer_Basement_SimParametersFields"; }
  domain value() const { return static_cast<domain>(EnumBase<GroundHeatTransfer_Basement_SimParametersFields>::integer_value()); }
   private:
    friend class EnumBase<GroundHeatTransfer_Basement_SimParametersFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ GroundHeatTransfer_Basement_SimParametersFields::F_MultiplierfortheADIsolution, "F_MultiplierfortheADIsolution", "F: Multiplier for the ADI solution"},
{ GroundHeatTransfer_Basement_SimParametersFields::IYRS_Maximumnumberofyearlyiterations_, "IYRS_Maximumnumberofyearlyiterations_", "IYRS: Maximum number of yearly iterations:"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const GroundHeatTransfer_Basement_SimParametersFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<GroundHeatTransfer_Basement_SimParametersFields> OptionalGroundHeatTransfer_Basement_SimParametersFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_GROUNDHEATTRANSFER_BASEMENT_SIMPARAMETERS_FIELDENUMS_HXX
