/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SIMULATIONCONTROL_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SIMULATIONCONTROL_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SimulationControlFields
 *  \brief Enumeration of OS:SimulationControl's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SimulationControlFields, )
#else
class OS_SimulationControlFields: public ::EnumBase<OS_SimulationControlFields> {
 public: 
  enum domain 
  {
Handle, DoZoneSizingCalculation, DoSystemSizingCalculation, DoPlantSizingCalculation, RunSimulationforSizingPeriods, RunSimulationforWeatherFileRunPeriods, LoadsConvergenceToleranceValue, TemperatureConvergenceToleranceValue, SolarDistribution, MaximumNumberofWarmupDays, MinimumNumberofWarmupDays, DoHVACSizingSimulationforSizingPeriods, MaximumNumberofHVACSizingSimulationPasses,   };
  OS_SimulationControlFields()
   : EnumBase<OS_SimulationControlFields>(Handle) {} 
  OS_SimulationControlFields(const std::string &t_name) 
   : EnumBase<OS_SimulationControlFields>(t_name) {} 
  OS_SimulationControlFields(int t_value) 
   : EnumBase<OS_SimulationControlFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SimulationControlFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SimulationControlFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SimulationControlFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SimulationControlFields::Handle, "Handle", "Handle"},
{ OS_SimulationControlFields::DoZoneSizingCalculation, "DoZoneSizingCalculation", "Do Zone Sizing Calculation"},
{ OS_SimulationControlFields::DoSystemSizingCalculation, "DoSystemSizingCalculation", "Do System Sizing Calculation"},
{ OS_SimulationControlFields::DoPlantSizingCalculation, "DoPlantSizingCalculation", "Do Plant Sizing Calculation"},
{ OS_SimulationControlFields::RunSimulationforSizingPeriods, "RunSimulationforSizingPeriods", "Run Simulation for Sizing Periods"},
{ OS_SimulationControlFields::RunSimulationforWeatherFileRunPeriods, "RunSimulationforWeatherFileRunPeriods", "Run Simulation for Weather File Run Periods"},
{ OS_SimulationControlFields::LoadsConvergenceToleranceValue, "LoadsConvergenceToleranceValue", "Loads Convergence Tolerance Value"},
{ OS_SimulationControlFields::TemperatureConvergenceToleranceValue, "TemperatureConvergenceToleranceValue", "Temperature Convergence Tolerance Value"},
{ OS_SimulationControlFields::SolarDistribution, "SolarDistribution", "Solar Distribution"},
{ OS_SimulationControlFields::MaximumNumberofWarmupDays, "MaximumNumberofWarmupDays", "Maximum Number of Warmup Days"},
{ OS_SimulationControlFields::MinimumNumberofWarmupDays, "MinimumNumberofWarmupDays", "Minimum Number of Warmup Days"},
{ OS_SimulationControlFields::DoHVACSizingSimulationforSizingPeriods, "DoHVACSizingSimulationforSizingPeriods", "Do HVAC Sizing Simulation for Sizing Periods"},
{ OS_SimulationControlFields::MaximumNumberofHVACSizingSimulationPasses, "MaximumNumberofHVACSizingSimulationPasses", "Maximum Number of HVAC Sizing Simulation Passes"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SimulationControlFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SimulationControlFields> OptionalOS_SimulationControlFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SIMULATIONCONTROL_FIELDENUMS_HXX
