/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

namespace openstudio {
/** \page units_page OpenStudio Units
 *
 *  The runtime units utility is intended to serve as the units gateway between users and OpenStudio.
 *  It supports IP units, Btus, etc., in addition to SI units. Construction, arithmetic operations,
 *  and unit conversions are supported in C++ and in the SWIG bindings.
 *
 * \section quick_links_units Quick Links
 *
 *  \li Quantity
 *  \li SIQuantity
 *  \li IPQuantity
 *  \li BTUQuantity
 *  \li CFMQuantity
 *  \li CelsiusQuantity
 *  \li FahrenheitQuantity
 *
 *  \li UnitFactory.hpp
 *  \li QuantityFactory.hpp
 *  \li QuantityConverter.hpp
 */
}  // namespace openstudio
