/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_SURFACEPROPERTY_CONVECTIONCOEFFICIENTS_MULTIPLESURFACE_FIELDENUMS_HXX
#define UTILITIES_IDD_SURFACEPROPERTY_CONVECTIONCOEFFICIENTS_MULTIPLESURFACE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields
 *  \brief Enumeration of SurfaceProperty:ConvectionCoefficients:MultipleSurface's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields, )
#else
class SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields: public ::EnumBase<SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields> {
 public: 
  enum domain 
  {
SurfaceType, ConvectionCoefficient1Location, ConvectionCoefficient1Type, ConvectionCoefficient1, ConvectionCoefficient1ScheduleName, ConvectionCoefficient1UserCurveName, ConvectionCoefficient2Location, ConvectionCoefficient2Type, ConvectionCoefficient2, ConvectionCoefficient2ScheduleName, ConvectionCoefficient2UserCurveName,   };
  SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields()
   : EnumBase<SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields>(SurfaceType) {} 
  SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields(const std::string &t_name) 
   : EnumBase<SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields>(t_name) {} 
  SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields(int t_value) 
   : EnumBase<SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields>(t_value) {} 
  static std::string enumName() 
  { return "SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields"; }
  domain value() const { return static_cast<domain>(EnumBase<SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields>::integer_value()); }
   private:
    friend class EnumBase<SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::SurfaceType, "SurfaceType", "Surface Type"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient1Location, "ConvectionCoefficient1Location", "Convection Coefficient 1 Location"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient1Type, "ConvectionCoefficient1Type", "Convection Coefficient 1 Type"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient1, "ConvectionCoefficient1", "Convection Coefficient 1"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient1ScheduleName, "ConvectionCoefficient1ScheduleName", "Convection Coefficient 1 Schedule Name"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient1UserCurveName, "ConvectionCoefficient1UserCurveName", "Convection Coefficient 1 User Curve Name"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient2Location, "ConvectionCoefficient2Location", "Convection Coefficient 2 Location"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient2Type, "ConvectionCoefficient2Type", "Convection Coefficient 2 Type"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient2, "ConvectionCoefficient2", "Convection Coefficient 2"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient2ScheduleName, "ConvectionCoefficient2ScheduleName", "Convection Coefficient 2 Schedule Name"},
{ SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields::ConvectionCoefficient2UserCurveName, "ConvectionCoefficient2UserCurveName", "Convection Coefficient 2 User Curve Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<SurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields> OptionalSurfaceProperty_ConvectionCoefficients_MultipleSurfaceFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_SURFACEPROPERTY_CONVECTIONCOEFFICIENTS_MULTIPLESURFACE_FIELDENUMS_HXX
