/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_ZONEHVAC_REFRIGERATIONCHILLERSET_FIELDENUMS_HXX
#define UTILITIES_IDD_ZONEHVAC_REFRIGERATIONCHILLERSET_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ZoneHVAC_RefrigerationChillerSetFields
 *  \brief Enumeration of ZoneHVAC:RefrigerationChillerSet's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ZoneHVAC_RefrigerationChillerSetFields, )
#else
class ZoneHVAC_RefrigerationChillerSetFields: public ::EnumBase<ZoneHVAC_RefrigerationChillerSetFields> {
 public: 
  enum domain 
  {
Name, AvailabilityScheduleName, ZoneName, AirInletNodeName, AirOutletNodeName,   };
  ZoneHVAC_RefrigerationChillerSetFields()
   : EnumBase<ZoneHVAC_RefrigerationChillerSetFields>(Name) {} 
  ZoneHVAC_RefrigerationChillerSetFields(const std::string &t_name) 
   : EnumBase<ZoneHVAC_RefrigerationChillerSetFields>(t_name) {} 
  ZoneHVAC_RefrigerationChillerSetFields(int t_value) 
   : EnumBase<ZoneHVAC_RefrigerationChillerSetFields>(t_value) {} 
  static std::string enumName() 
  { return "ZoneHVAC_RefrigerationChillerSetFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ZoneHVAC_RefrigerationChillerSetFields>::integer_value()); }
   private:
    friend class EnumBase<ZoneHVAC_RefrigerationChillerSetFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ZoneHVAC_RefrigerationChillerSetFields::Name, "Name", "Name"},
{ ZoneHVAC_RefrigerationChillerSetFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ ZoneHVAC_RefrigerationChillerSetFields::ZoneName, "ZoneName", "Zone Name"},
{ ZoneHVAC_RefrigerationChillerSetFields::AirInletNodeName, "AirInletNodeName", "Air Inlet Node Name"},
{ ZoneHVAC_RefrigerationChillerSetFields::AirOutletNodeName, "AirOutletNodeName", "Air Outlet Node Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ZoneHVAC_RefrigerationChillerSetFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ZoneHVAC_RefrigerationChillerSetFields> OptionalZoneHVAC_RefrigerationChillerSetFields ;
#endif

/** \class ZoneHVAC_RefrigerationChillerSetExtensibleFields
 *  \brief Enumeration of ZoneHVAC:RefrigerationChillerSet's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ZoneHVAC_RefrigerationChillerSetExtensibleFields, )
#else
class ZoneHVAC_RefrigerationChillerSetExtensibleFields: public ::EnumBase<ZoneHVAC_RefrigerationChillerSetExtensibleFields> {
 public: 
  enum domain 
  {
AirChillerName,   };
  ZoneHVAC_RefrigerationChillerSetExtensibleFields()
   : EnumBase<ZoneHVAC_RefrigerationChillerSetExtensibleFields>(AirChillerName) {} 
  ZoneHVAC_RefrigerationChillerSetExtensibleFields(const std::string &t_name) 
   : EnumBase<ZoneHVAC_RefrigerationChillerSetExtensibleFields>(t_name) {} 
  ZoneHVAC_RefrigerationChillerSetExtensibleFields(int t_value) 
   : EnumBase<ZoneHVAC_RefrigerationChillerSetExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "ZoneHVAC_RefrigerationChillerSetExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ZoneHVAC_RefrigerationChillerSetExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<ZoneHVAC_RefrigerationChillerSetExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ZoneHVAC_RefrigerationChillerSetExtensibleFields::AirChillerName, "AirChillerName", "Air Chiller Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ZoneHVAC_RefrigerationChillerSetExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ZoneHVAC_RefrigerationChillerSetExtensibleFields> OptionalZoneHVAC_RefrigerationChillerSetExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_ZONEHVAC_REFRIGERATIONCHILLERSET_FIELDENUMS_HXX
