/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_EVAPORATIVEFLUIDCOOLER_TWOSPEED_FIELDENUMS_HXX
#define UTILITIES_IDD_EVAPORATIVEFLUIDCOOLER_TWOSPEED_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class EvaporativeFluidCooler_TwoSpeedFields
 *  \brief Enumeration of EvaporativeFluidCooler:TwoSpeed's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(EvaporativeFluidCooler_TwoSpeedFields, )
#else
class EvaporativeFluidCooler_TwoSpeedFields: public ::EnumBase<EvaporativeFluidCooler_TwoSpeedFields> {
 public: 
  enum domain 
  {
Name, WaterInletNodeName, WaterOutletNodeName, HighFanSpeedAirFlowRate, HighFanSpeedFanPower, LowFanSpeedAirFlowRate, LowFanSpeedAirFlowRateSizingFactor, LowFanSpeedFanPower, LowFanSpeedFanPowerSizingFactor, DesignSprayWaterFlowRate, PerformanceInputMethod, OutdoorAirInletNodeName, HeatRejectionCapacityandNominalCapacitySizingRatio, HighSpeedStandardDesignCapacity, LowSpeedStandardDesignCapacity, LowSpeedStandardCapacitySizingFactor, HighFanSpeedUfactorTimesAreaValue, LowFanSpeedUfactorTimesAreaValue, LowFanSpeedUFactorTimesAreaSizingFactor, DesignWaterFlowRate, HighSpeedUserSpecifiedDesignCapacity, LowSpeedUserSpecifiedDesignCapacity, LowSpeedUserSpecifiedDesignCapacitySizingFactor, DesignEnteringWaterTemperature, DesignEnteringAirTemperature, DesignEnteringAirWetbulbTemperature, HighSpeedSizingFactor, EvaporationLossMode, EvaporationLossFactor, DriftLossPercent, BlowdownCalculationMode, BlowdownConcentrationRatio, BlowdownMakeupWaterUsageScheduleName, SupplyWaterStorageTankName,   };
  EvaporativeFluidCooler_TwoSpeedFields()
   : EnumBase<EvaporativeFluidCooler_TwoSpeedFields>(Name) {} 
  EvaporativeFluidCooler_TwoSpeedFields(const std::string &t_name) 
   : EnumBase<EvaporativeFluidCooler_TwoSpeedFields>(t_name) {} 
  EvaporativeFluidCooler_TwoSpeedFields(int t_value) 
   : EnumBase<EvaporativeFluidCooler_TwoSpeedFields>(t_value) {} 
  static std::string enumName() 
  { return "EvaporativeFluidCooler_TwoSpeedFields"; }
  domain value() const { return static_cast<domain>(EnumBase<EvaporativeFluidCooler_TwoSpeedFields>::integer_value()); }
   private:
    friend class EnumBase<EvaporativeFluidCooler_TwoSpeedFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ EvaporativeFluidCooler_TwoSpeedFields::Name, "Name", "Name"},
{ EvaporativeFluidCooler_TwoSpeedFields::WaterInletNodeName, "WaterInletNodeName", "Water Inlet Node Name"},
{ EvaporativeFluidCooler_TwoSpeedFields::WaterOutletNodeName, "WaterOutletNodeName", "Water Outlet Node Name"},
{ EvaporativeFluidCooler_TwoSpeedFields::HighFanSpeedAirFlowRate, "HighFanSpeedAirFlowRate", "High Fan Speed Air Flow Rate"},
{ EvaporativeFluidCooler_TwoSpeedFields::HighFanSpeedFanPower, "HighFanSpeedFanPower", "High Fan Speed Fan Power"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowFanSpeedAirFlowRate, "LowFanSpeedAirFlowRate", "Low Fan Speed Air Flow Rate"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowFanSpeedAirFlowRateSizingFactor, "LowFanSpeedAirFlowRateSizingFactor", "Low Fan Speed Air Flow Rate Sizing Factor"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowFanSpeedFanPower, "LowFanSpeedFanPower", "Low Fan Speed Fan Power"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowFanSpeedFanPowerSizingFactor, "LowFanSpeedFanPowerSizingFactor", "Low Fan Speed Fan Power Sizing Factor"},
{ EvaporativeFluidCooler_TwoSpeedFields::DesignSprayWaterFlowRate, "DesignSprayWaterFlowRate", "Design Spray Water Flow Rate"},
{ EvaporativeFluidCooler_TwoSpeedFields::PerformanceInputMethod, "PerformanceInputMethod", "Performance Input Method"},
{ EvaporativeFluidCooler_TwoSpeedFields::OutdoorAirInletNodeName, "OutdoorAirInletNodeName", "Outdoor Air Inlet Node Name"},
{ EvaporativeFluidCooler_TwoSpeedFields::HeatRejectionCapacityandNominalCapacitySizingRatio, "HeatRejectionCapacityandNominalCapacitySizingRatio", "Heat Rejection Capacity and Nominal Capacity Sizing Ratio"},
{ EvaporativeFluidCooler_TwoSpeedFields::HighSpeedStandardDesignCapacity, "HighSpeedStandardDesignCapacity", "High Speed Standard Design Capacity"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowSpeedStandardDesignCapacity, "LowSpeedStandardDesignCapacity", "Low Speed Standard Design Capacity"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowSpeedStandardCapacitySizingFactor, "LowSpeedStandardCapacitySizingFactor", "Low Speed Standard Capacity Sizing Factor"},
{ EvaporativeFluidCooler_TwoSpeedFields::HighFanSpeedUfactorTimesAreaValue, "HighFanSpeedUfactorTimesAreaValue", "High Fan Speed U-factor Times Area Value"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowFanSpeedUfactorTimesAreaValue, "LowFanSpeedUfactorTimesAreaValue", "Low Fan Speed U-factor Times Area Value"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowFanSpeedUFactorTimesAreaSizingFactor, "LowFanSpeedUFactorTimesAreaSizingFactor", "Low Fan Speed U-Factor Times Area Sizing Factor"},
{ EvaporativeFluidCooler_TwoSpeedFields::DesignWaterFlowRate, "DesignWaterFlowRate", "Design Water Flow Rate"},
{ EvaporativeFluidCooler_TwoSpeedFields::HighSpeedUserSpecifiedDesignCapacity, "HighSpeedUserSpecifiedDesignCapacity", "High Speed User Specified Design Capacity"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowSpeedUserSpecifiedDesignCapacity, "LowSpeedUserSpecifiedDesignCapacity", "Low Speed User Specified Design Capacity"},
{ EvaporativeFluidCooler_TwoSpeedFields::LowSpeedUserSpecifiedDesignCapacitySizingFactor, "LowSpeedUserSpecifiedDesignCapacitySizingFactor", "Low Speed User Specified Design Capacity Sizing Factor"},
{ EvaporativeFluidCooler_TwoSpeedFields::DesignEnteringWaterTemperature, "DesignEnteringWaterTemperature", "Design Entering Water Temperature"},
{ EvaporativeFluidCooler_TwoSpeedFields::DesignEnteringAirTemperature, "DesignEnteringAirTemperature", "Design Entering Air Temperature"},
{ EvaporativeFluidCooler_TwoSpeedFields::DesignEnteringAirWetbulbTemperature, "DesignEnteringAirWetbulbTemperature", "Design Entering Air Wet-bulb Temperature"},
{ EvaporativeFluidCooler_TwoSpeedFields::HighSpeedSizingFactor, "HighSpeedSizingFactor", "High Speed Sizing Factor"},
{ EvaporativeFluidCooler_TwoSpeedFields::EvaporationLossMode, "EvaporationLossMode", "Evaporation Loss Mode"},
{ EvaporativeFluidCooler_TwoSpeedFields::EvaporationLossFactor, "EvaporationLossFactor", "Evaporation Loss Factor"},
{ EvaporativeFluidCooler_TwoSpeedFields::DriftLossPercent, "DriftLossPercent", "Drift Loss Percent"},
{ EvaporativeFluidCooler_TwoSpeedFields::BlowdownCalculationMode, "BlowdownCalculationMode", "Blowdown Calculation Mode"},
{ EvaporativeFluidCooler_TwoSpeedFields::BlowdownConcentrationRatio, "BlowdownConcentrationRatio", "Blowdown Concentration Ratio"},
{ EvaporativeFluidCooler_TwoSpeedFields::BlowdownMakeupWaterUsageScheduleName, "BlowdownMakeupWaterUsageScheduleName", "Blowdown Makeup Water Usage Schedule Name"},
{ EvaporativeFluidCooler_TwoSpeedFields::SupplyWaterStorageTankName, "SupplyWaterStorageTankName", "Supply Water Storage Tank Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const EvaporativeFluidCooler_TwoSpeedFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<EvaporativeFluidCooler_TwoSpeedFields> OptionalEvaporativeFluidCooler_TwoSpeedFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_EVAPORATIVEFLUIDCOOLER_TWOSPEED_FIELDENUMS_HXX
