/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_GROUNDHEATEXCHANGER_SURFACE_FIELDENUMS_HXX
#define UTILITIES_IDD_GROUNDHEATEXCHANGER_SURFACE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class GroundHeatExchanger_SurfaceFields
 *  \brief Enumeration of GroundHeatExchanger:Surface's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(GroundHeatExchanger_SurfaceFields, )
#else
class GroundHeatExchanger_SurfaceFields: public ::EnumBase<GroundHeatExchanger_SurfaceFields> {
 public: 
  enum domain 
  {
Name, ConstructionName, FluidInletNodeName, FluidOutletNodeName, HydronicTubingInsideDiameter, NumberofTubingCircuits, HydronicTubeSpacing, SurfaceLength, SurfaceWidth, LowerSurfaceEnvironment,   };
  GroundHeatExchanger_SurfaceFields()
   : EnumBase<GroundHeatExchanger_SurfaceFields>(Name) {} 
  GroundHeatExchanger_SurfaceFields(const std::string &t_name) 
   : EnumBase<GroundHeatExchanger_SurfaceFields>(t_name) {} 
  GroundHeatExchanger_SurfaceFields(int t_value) 
   : EnumBase<GroundHeatExchanger_SurfaceFields>(t_value) {} 
  static std::string enumName() 
  { return "GroundHeatExchanger_SurfaceFields"; }
  domain value() const { return static_cast<domain>(EnumBase<GroundHeatExchanger_SurfaceFields>::integer_value()); }
   private:
    friend class EnumBase<GroundHeatExchanger_SurfaceFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ GroundHeatExchanger_SurfaceFields::Name, "Name", "Name"},
{ GroundHeatExchanger_SurfaceFields::ConstructionName, "ConstructionName", "Construction Name"},
{ GroundHeatExchanger_SurfaceFields::FluidInletNodeName, "FluidInletNodeName", "Fluid Inlet Node Name"},
{ GroundHeatExchanger_SurfaceFields::FluidOutletNodeName, "FluidOutletNodeName", "Fluid Outlet Node Name"},
{ GroundHeatExchanger_SurfaceFields::HydronicTubingInsideDiameter, "HydronicTubingInsideDiameter", "Hydronic Tubing Inside Diameter"},
{ GroundHeatExchanger_SurfaceFields::NumberofTubingCircuits, "NumberofTubingCircuits", "Number of Tubing Circuits"},
{ GroundHeatExchanger_SurfaceFields::HydronicTubeSpacing, "HydronicTubeSpacing", "Hydronic Tube Spacing"},
{ GroundHeatExchanger_SurfaceFields::SurfaceLength, "SurfaceLength", "Surface Length"},
{ GroundHeatExchanger_SurfaceFields::SurfaceWidth, "SurfaceWidth", "Surface Width"},
{ GroundHeatExchanger_SurfaceFields::LowerSurfaceEnvironment, "LowerSurfaceEnvironment", "Lower Surface Environment"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const GroundHeatExchanger_SurfaceFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<GroundHeatExchanger_SurfaceFields> OptionalGroundHeatExchanger_SurfaceFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_GROUNDHEATEXCHANGER_SURFACE_FIELDENUMS_HXX
