/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_FAN_ZONEEXHAUST_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_FAN_ZONEEXHAUST_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Fan_ZoneExhaustFields
 *  \brief Enumeration of OS:Fan:ZoneExhaust's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Fan_ZoneExhaustFields, )
#else
class OS_Fan_ZoneExhaustFields: public ::EnumBase<OS_Fan_ZoneExhaustFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilityScheduleName, FanTotalEfficiency, PressureRise, MaximumFlowRate, AirInletNodeName, AirOutletNodeName, EndUseSubcategory, FlowFractionScheduleName, SystemAvailabilityManagerCouplingMode, MinimumZoneTemperatureLimitScheduleName, BalancedExhaustFractionScheduleName,   };
  OS_Fan_ZoneExhaustFields()
   : EnumBase<OS_Fan_ZoneExhaustFields>(Handle) {} 
  OS_Fan_ZoneExhaustFields(const std::string &t_name) 
   : EnumBase<OS_Fan_ZoneExhaustFields>(t_name) {} 
  OS_Fan_ZoneExhaustFields(int t_value) 
   : EnumBase<OS_Fan_ZoneExhaustFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Fan_ZoneExhaustFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Fan_ZoneExhaustFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Fan_ZoneExhaustFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Fan_ZoneExhaustFields::Handle, "Handle", "Handle"},
{ OS_Fan_ZoneExhaustFields::Name, "Name", "Name"},
{ OS_Fan_ZoneExhaustFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ OS_Fan_ZoneExhaustFields::FanTotalEfficiency, "FanTotalEfficiency", "Fan Total Efficiency"},
{ OS_Fan_ZoneExhaustFields::PressureRise, "PressureRise", "Pressure Rise"},
{ OS_Fan_ZoneExhaustFields::MaximumFlowRate, "MaximumFlowRate", "Maximum Flow Rate"},
{ OS_Fan_ZoneExhaustFields::AirInletNodeName, "AirInletNodeName", "Air Inlet Node Name"},
{ OS_Fan_ZoneExhaustFields::AirOutletNodeName, "AirOutletNodeName", "Air Outlet Node Name"},
{ OS_Fan_ZoneExhaustFields::EndUseSubcategory, "EndUseSubcategory", "End-Use Subcategory"},
{ OS_Fan_ZoneExhaustFields::FlowFractionScheduleName, "FlowFractionScheduleName", "Flow Fraction Schedule Name"},
{ OS_Fan_ZoneExhaustFields::SystemAvailabilityManagerCouplingMode, "SystemAvailabilityManagerCouplingMode", "System Availability Manager Coupling Mode"},
{ OS_Fan_ZoneExhaustFields::MinimumZoneTemperatureLimitScheduleName, "MinimumZoneTemperatureLimitScheduleName", "Minimum Zone Temperature Limit Schedule Name"},
{ OS_Fan_ZoneExhaustFields::BalancedExhaustFractionScheduleName, "BalancedExhaustFractionScheduleName", "Balanced Exhaust Fraction Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Fan_ZoneExhaustFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Fan_ZoneExhaustFields> OptionalOS_Fan_ZoneExhaustFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_FAN_ZONEEXHAUST_FIELDENUMS_HXX
