/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_LUMINAIRE_DEFINITION_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_LUMINAIRE_DEFINITION_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Luminaire_DefinitionFields
 *  \brief Enumeration of OS:Luminaire:Definition's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Luminaire_DefinitionFields, )
#else
class OS_Luminaire_DefinitionFields: public ::EnumBase<OS_Luminaire_DefinitionFields> {
 public: 
  enum domain 
  {
Handle, Name, IESFilePath, LightingPower, FractionRadiant, FractionVisible, ReturnAirFraction, ReturnAirFractionCalculatedfromPlenumTemperature, ReturnAirFractionFunctionofPlenumTemperatureCoefficient1, ReturnAirFractionFunctionofPlenumTemperatureCoefficient2,   };
  OS_Luminaire_DefinitionFields()
   : EnumBase<OS_Luminaire_DefinitionFields>(Handle) {} 
  OS_Luminaire_DefinitionFields(const std::string &t_name) 
   : EnumBase<OS_Luminaire_DefinitionFields>(t_name) {} 
  OS_Luminaire_DefinitionFields(int t_value) 
   : EnumBase<OS_Luminaire_DefinitionFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Luminaire_DefinitionFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Luminaire_DefinitionFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Luminaire_DefinitionFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Luminaire_DefinitionFields::Handle, "Handle", "Handle"},
{ OS_Luminaire_DefinitionFields::Name, "Name", "Name"},
{ OS_Luminaire_DefinitionFields::IESFilePath, "IESFilePath", "IES File Path"},
{ OS_Luminaire_DefinitionFields::LightingPower, "LightingPower", "Lighting Power"},
{ OS_Luminaire_DefinitionFields::FractionRadiant, "FractionRadiant", "Fraction Radiant"},
{ OS_Luminaire_DefinitionFields::FractionVisible, "FractionVisible", "Fraction Visible"},
{ OS_Luminaire_DefinitionFields::ReturnAirFraction, "ReturnAirFraction", "Return Air Fraction"},
{ OS_Luminaire_DefinitionFields::ReturnAirFractionCalculatedfromPlenumTemperature, "ReturnAirFractionCalculatedfromPlenumTemperature", "Return Air Fraction Calculated from Plenum Temperature"},
{ OS_Luminaire_DefinitionFields::ReturnAirFractionFunctionofPlenumTemperatureCoefficient1, "ReturnAirFractionFunctionofPlenumTemperatureCoefficient1", "Return Air Fraction Function of Plenum Temperature Coefficient 1"},
{ OS_Luminaire_DefinitionFields::ReturnAirFractionFunctionofPlenumTemperatureCoefficient2, "ReturnAirFractionFunctionofPlenumTemperatureCoefficient2", "Return Air Fraction Function of Plenum Temperature Coefficient 2"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Luminaire_DefinitionFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Luminaire_DefinitionFields> OptionalOS_Luminaire_DefinitionFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_LUMINAIRE_DEFINITION_FIELDENUMS_HXX
