/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_SCHEDULETYPELIMITS_FIELDENUMS_HXX
#define UTILITIES_IDD_SCHEDULETYPELIMITS_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ScheduleTypeLimitsFields
 *  \brief Enumeration of ScheduleTypeLimits's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ScheduleTypeLimitsFields, )
#else
class ScheduleTypeLimitsFields: public ::EnumBase<ScheduleTypeLimitsFields> {
 public: 
  enum domain 
  {
Name, LowerLimitValue, UpperLimitValue, NumericType, UnitType,   };
  ScheduleTypeLimitsFields()
   : EnumBase<ScheduleTypeLimitsFields>(Name) {} 
  ScheduleTypeLimitsFields(const std::string &t_name) 
   : EnumBase<ScheduleTypeLimitsFields>(t_name) {} 
  ScheduleTypeLimitsFields(int t_value) 
   : EnumBase<ScheduleTypeLimitsFields>(t_value) {} 
  static std::string enumName() 
  { return "ScheduleTypeLimitsFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ScheduleTypeLimitsFields>::integer_value()); }
   private:
    friend class EnumBase<ScheduleTypeLimitsFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ScheduleTypeLimitsFields::Name, "Name", "Name"},
{ ScheduleTypeLimitsFields::LowerLimitValue, "LowerLimitValue", "Lower Limit Value"},
{ ScheduleTypeLimitsFields::UpperLimitValue, "UpperLimitValue", "Upper Limit Value"},
{ ScheduleTypeLimitsFields::NumericType, "NumericType", "Numeric Type"},
{ ScheduleTypeLimitsFields::UnitType, "UnitType", "Unit Type"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ScheduleTypeLimitsFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ScheduleTypeLimitsFields> OptionalScheduleTypeLimitsFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_SCHEDULETYPELIMITS_FIELDENUMS_HXX
