/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_DISTRICTHEATING_WATER_FIELDENUMS_HXX
#define UTILITIES_IDD_DISTRICTHEATING_WATER_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class DistrictHeating_WaterFields
 *  \brief Enumeration of DistrictHeating:Water's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(DistrictHeating_WaterFields, )
#else
class DistrictHeating_WaterFields: public ::EnumBase<DistrictHeating_WaterFields> {
 public: 
  enum domain 
  {
Name, HotWaterInletNodeName, HotWaterOutletNodeName, NominalCapacity, CapacityFractionScheduleName,   };
  DistrictHeating_WaterFields()
   : EnumBase<DistrictHeating_WaterFields>(Name) {} 
  DistrictHeating_WaterFields(const std::string &t_name) 
   : EnumBase<DistrictHeating_WaterFields>(t_name) {} 
  DistrictHeating_WaterFields(int t_value) 
   : EnumBase<DistrictHeating_WaterFields>(t_value) {} 
  static std::string enumName() 
  { return "DistrictHeating_WaterFields"; }
  domain value() const { return static_cast<domain>(EnumBase<DistrictHeating_WaterFields>::integer_value()); }
   private:
    friend class EnumBase<DistrictHeating_WaterFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ DistrictHeating_WaterFields::Name, "Name", "Name"},
{ DistrictHeating_WaterFields::HotWaterInletNodeName, "HotWaterInletNodeName", "Hot Water Inlet Node Name"},
{ DistrictHeating_WaterFields::HotWaterOutletNodeName, "HotWaterOutletNodeName", "Hot Water Outlet Node Name"},
{ DistrictHeating_WaterFields::NominalCapacity, "NominalCapacity", "Nominal Capacity"},
{ DistrictHeating_WaterFields::CapacityFractionScheduleName, "CapacityFractionScheduleName", "Capacity Fraction Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const DistrictHeating_WaterFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<DistrictHeating_WaterFields> OptionalDistrictHeating_WaterFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_DISTRICTHEATING_WATER_FIELDENUMS_HXX
