/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_DISTRICTCOOLING_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_DISTRICTCOOLING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_DistrictCoolingFields
 *  \brief Enumeration of OS:DistrictCooling's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_DistrictCoolingFields, )
#else
class OS_DistrictCoolingFields: public ::EnumBase<OS_DistrictCoolingFields> {
 public: 
  enum domain 
  {
Handle, Name, ChilledWaterInletNodeName, ChilledWaterOutletNodeName, NominalCapacity, CapacityFractionSchedule,   };
  OS_DistrictCoolingFields()
   : EnumBase<OS_DistrictCoolingFields>(Handle) {} 
  OS_DistrictCoolingFields(const std::string &t_name) 
   : EnumBase<OS_DistrictCoolingFields>(t_name) {} 
  OS_DistrictCoolingFields(int t_value) 
   : EnumBase<OS_DistrictCoolingFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_DistrictCoolingFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_DistrictCoolingFields>::integer_value()); }
   private:
    friend class EnumBase<OS_DistrictCoolingFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_DistrictCoolingFields::Handle, "Handle", "Handle"},
{ OS_DistrictCoolingFields::Name, "Name", "Name"},
{ OS_DistrictCoolingFields::ChilledWaterInletNodeName, "ChilledWaterInletNodeName", "Chilled Water Inlet Node Name"},
{ OS_DistrictCoolingFields::ChilledWaterOutletNodeName, "ChilledWaterOutletNodeName", "Chilled Water Outlet Node Name"},
{ OS_DistrictCoolingFields::NominalCapacity, "NominalCapacity", "Nominal Capacity"},
{ OS_DistrictCoolingFields::CapacityFractionSchedule, "CapacityFractionSchedule", "Capacity Fraction Schedule"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_DistrictCoolingFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_DistrictCoolingFields> OptionalOS_DistrictCoolingFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_DISTRICTCOOLING_FIELDENUMS_HXX
