/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_WINDOWMATERIAL_SIMPLEGLAZINGSYSTEM_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_WINDOWMATERIAL_SIMPLEGLAZINGSYSTEM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_WindowMaterial_SimpleGlazingSystemFields
 *  \brief Enumeration of OS:WindowMaterial:SimpleGlazingSystem's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_WindowMaterial_SimpleGlazingSystemFields, )
#else
class OS_WindowMaterial_SimpleGlazingSystemFields: public ::EnumBase<OS_WindowMaterial_SimpleGlazingSystemFields> {
 public: 
  enum domain 
  {
Handle, Name, UFactor, SolarHeatGainCoefficient, VisibleTransmittance,   };
  OS_WindowMaterial_SimpleGlazingSystemFields()
   : EnumBase<OS_WindowMaterial_SimpleGlazingSystemFields>(Handle) {} 
  OS_WindowMaterial_SimpleGlazingSystemFields(const std::string &t_name) 
   : EnumBase<OS_WindowMaterial_SimpleGlazingSystemFields>(t_name) {} 
  OS_WindowMaterial_SimpleGlazingSystemFields(int t_value) 
   : EnumBase<OS_WindowMaterial_SimpleGlazingSystemFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_WindowMaterial_SimpleGlazingSystemFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_WindowMaterial_SimpleGlazingSystemFields>::integer_value()); }
   private:
    friend class EnumBase<OS_WindowMaterial_SimpleGlazingSystemFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_WindowMaterial_SimpleGlazingSystemFields::Handle, "Handle", "Handle"},
{ OS_WindowMaterial_SimpleGlazingSystemFields::Name, "Name", "Name"},
{ OS_WindowMaterial_SimpleGlazingSystemFields::UFactor, "UFactor", "U-Factor"},
{ OS_WindowMaterial_SimpleGlazingSystemFields::SolarHeatGainCoefficient, "SolarHeatGainCoefficient", "Solar Heat Gain Coefficient"},
{ OS_WindowMaterial_SimpleGlazingSystemFields::VisibleTransmittance, "VisibleTransmittance", "Visible Transmittance"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_WindowMaterial_SimpleGlazingSystemFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_WindowMaterial_SimpleGlazingSystemFields> OptionalOS_WindowMaterial_SimpleGlazingSystemFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_WINDOWMATERIAL_SIMPLEGLAZINGSYSTEM_FIELDENUMS_HXX
