/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AVAILABILITYMANAGER_SCHEDULED_FIELDENUMS_HXX
#define UTILITIES_IDD_AVAILABILITYMANAGER_SCHEDULED_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AvailabilityManager_ScheduledFields
 *  \brief Enumeration of AvailabilityManager:Scheduled's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AvailabilityManager_ScheduledFields, )
#else
class AvailabilityManager_ScheduledFields: public ::EnumBase<AvailabilityManager_ScheduledFields> {
 public: 
  enum domain 
  {
Name, ScheduleName,   };
  AvailabilityManager_ScheduledFields()
   : EnumBase<AvailabilityManager_ScheduledFields>(Name) {} 
  AvailabilityManager_ScheduledFields(const std::string &t_name) 
   : EnumBase<AvailabilityManager_ScheduledFields>(t_name) {} 
  AvailabilityManager_ScheduledFields(int t_value) 
   : EnumBase<AvailabilityManager_ScheduledFields>(t_value) {} 
  static std::string enumName() 
  { return "AvailabilityManager_ScheduledFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AvailabilityManager_ScheduledFields>::integer_value()); }
   private:
    friend class EnumBase<AvailabilityManager_ScheduledFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AvailabilityManager_ScheduledFields::Name, "Name", "Name"},
{ AvailabilityManager_ScheduledFields::ScheduleName, "ScheduleName", "Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AvailabilityManager_ScheduledFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AvailabilityManager_ScheduledFields> OptionalAvailabilityManager_ScheduledFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AVAILABILITYMANAGER_SCHEDULED_FIELDENUMS_HXX
