/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_FACILITY_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_FACILITY_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_FacilityFields
 *  \brief Enumeration of OS:Facility's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_FacilityFields, )
#else
class OS_FacilityFields: public ::EnumBase<OS_FacilityFields> {
 public: 
  enum domain 
  {
Handle,   };
  OS_FacilityFields()
   : EnumBase<OS_FacilityFields>(Handle) {} 
  OS_FacilityFields(const std::string &t_name) 
   : EnumBase<OS_FacilityFields>(t_name) {} 
  OS_FacilityFields(int t_value) 
   : EnumBase<OS_FacilityFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_FacilityFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_FacilityFields>::integer_value()); }
   private:
    friend class EnumBase<OS_FacilityFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_FacilityFields::Handle, "Handle", "Handle"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_FacilityFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_FacilityFields> OptionalOS_FacilityFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_FACILITY_FIELDENUMS_HXX
