/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_PHOTOVOLTAICPERFORMANCE_SANDIA_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_PHOTOVOLTAICPERFORMANCE_SANDIA_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_PhotovoltaicPerformance_SandiaFields
 *  \brief Enumeration of OS:PhotovoltaicPerformance:Sandia's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_PhotovoltaicPerformance_SandiaFields, )
#else
class OS_PhotovoltaicPerformance_SandiaFields: public ::EnumBase<OS_PhotovoltaicPerformance_SandiaFields> {
 public: 
  enum domain 
  {
Handle, Name, ActiveArea, NumberofCellsinSeries, NumberofCellsinParallel, ShortCircuitCurrent, OpenCircuitVoltage, CurrentatMaximumPowerPoint, VoltageatMaximumPowerPoint, SandiaDatabaseParameteraIsc, SandiaDatabaseParameteraImp, SandiaDatabaseParameterc0, SandiaDatabaseParameterc1, SandiaDatabaseParameterBVoc0, SandiaDatabaseParametermBVoc, SandiaDatabaseParameterBVmp0, SandiaDatabaseParametermBVmp, DiodeFactor, SandiaDatabaseParameterc2, SandiaDatabaseParameterc3, SandiaDatabaseParametera0, SandiaDatabaseParametera1, SandiaDatabaseParametera2, SandiaDatabaseParametera3, SandiaDatabaseParametera4, SandiaDatabaseParameterb0, SandiaDatabaseParameterb1, SandiaDatabaseParameterb2, SandiaDatabaseParameterb3, SandiaDatabaseParameterb4, SandiaDatabaseParameterb5, SandiaDatabaseParameterDelta_Tc_, SandiaDatabaseParameterfd, SandiaDatabaseParametera, SandiaDatabaseParameterb, SandiaDatabaseParameterc4, SandiaDatabaseParameterc5, SandiaDatabaseParameterIx0, SandiaDatabaseParameterIxx0, SandiaDatabaseParameterc6, SandiaDatabaseParameterc7,   };
  OS_PhotovoltaicPerformance_SandiaFields()
   : EnumBase<OS_PhotovoltaicPerformance_SandiaFields>(Handle) {} 
  OS_PhotovoltaicPerformance_SandiaFields(const std::string &t_name) 
   : EnumBase<OS_PhotovoltaicPerformance_SandiaFields>(t_name) {} 
  OS_PhotovoltaicPerformance_SandiaFields(int t_value) 
   : EnumBase<OS_PhotovoltaicPerformance_SandiaFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_PhotovoltaicPerformance_SandiaFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_PhotovoltaicPerformance_SandiaFields>::integer_value()); }
   private:
    friend class EnumBase<OS_PhotovoltaicPerformance_SandiaFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_PhotovoltaicPerformance_SandiaFields::Handle, "Handle", "Handle"},
{ OS_PhotovoltaicPerformance_SandiaFields::Name, "Name", "Name"},
{ OS_PhotovoltaicPerformance_SandiaFields::ActiveArea, "ActiveArea", "Active Area"},
{ OS_PhotovoltaicPerformance_SandiaFields::NumberofCellsinSeries, "NumberofCellsinSeries", "Number of Cells in Series"},
{ OS_PhotovoltaicPerformance_SandiaFields::NumberofCellsinParallel, "NumberofCellsinParallel", "Number of Cells in Parallel"},
{ OS_PhotovoltaicPerformance_SandiaFields::ShortCircuitCurrent, "ShortCircuitCurrent", "Short Circuit Current"},
{ OS_PhotovoltaicPerformance_SandiaFields::OpenCircuitVoltage, "OpenCircuitVoltage", "Open Circuit Voltage"},
{ OS_PhotovoltaicPerformance_SandiaFields::CurrentatMaximumPowerPoint, "CurrentatMaximumPowerPoint", "Current at Maximum Power Point"},
{ OS_PhotovoltaicPerformance_SandiaFields::VoltageatMaximumPowerPoint, "VoltageatMaximumPowerPoint", "Voltage at Maximum Power Point"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameteraIsc, "SandiaDatabaseParameteraIsc", "Sandia Database Parameter aIsc"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameteraImp, "SandiaDatabaseParameteraImp", "Sandia Database Parameter aImp"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc0, "SandiaDatabaseParameterc0", "Sandia Database Parameter c0"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc1, "SandiaDatabaseParameterc1", "Sandia Database Parameter c1"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterBVoc0, "SandiaDatabaseParameterBVoc0", "Sandia Database Parameter BVoc0"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametermBVoc, "SandiaDatabaseParametermBVoc", "Sandia Database Parameter mBVoc"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterBVmp0, "SandiaDatabaseParameterBVmp0", "Sandia Database Parameter BVmp0"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametermBVmp, "SandiaDatabaseParametermBVmp", "Sandia Database Parameter mBVmp"},
{ OS_PhotovoltaicPerformance_SandiaFields::DiodeFactor, "DiodeFactor", "Diode Factor"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc2, "SandiaDatabaseParameterc2", "Sandia Database Parameter c2"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc3, "SandiaDatabaseParameterc3", "Sandia Database Parameter c3"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametera0, "SandiaDatabaseParametera0", "Sandia Database Parameter a0"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametera1, "SandiaDatabaseParametera1", "Sandia Database Parameter a1"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametera2, "SandiaDatabaseParametera2", "Sandia Database Parameter a2"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametera3, "SandiaDatabaseParametera3", "Sandia Database Parameter a3"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametera4, "SandiaDatabaseParametera4", "Sandia Database Parameter a4"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterb0, "SandiaDatabaseParameterb0", "Sandia Database Parameter b0"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterb1, "SandiaDatabaseParameterb1", "Sandia Database Parameter b1"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterb2, "SandiaDatabaseParameterb2", "Sandia Database Parameter b2"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterb3, "SandiaDatabaseParameterb3", "Sandia Database Parameter b3"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterb4, "SandiaDatabaseParameterb4", "Sandia Database Parameter b4"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterb5, "SandiaDatabaseParameterb5", "Sandia Database Parameter b5"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterDelta_Tc_, "SandiaDatabaseParameterDelta_Tc_", "Sandia Database Parameter Delta(Tc)"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterfd, "SandiaDatabaseParameterfd", "Sandia Database Parameter fd"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParametera, "SandiaDatabaseParametera", "Sandia Database Parameter a"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterb, "SandiaDatabaseParameterb", "Sandia Database Parameter b"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc4, "SandiaDatabaseParameterc4", "Sandia Database Parameter c4"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc5, "SandiaDatabaseParameterc5", "Sandia Database Parameter c5"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterIx0, "SandiaDatabaseParameterIx0", "Sandia Database Parameter Ix0"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterIxx0, "SandiaDatabaseParameterIxx0", "Sandia Database Parameter Ixx0"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc6, "SandiaDatabaseParameterc6", "Sandia Database Parameter c6"},
{ OS_PhotovoltaicPerformance_SandiaFields::SandiaDatabaseParameterc7, "SandiaDatabaseParameterc7", "Sandia Database Parameter c7"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_PhotovoltaicPerformance_SandiaFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_PhotovoltaicPerformance_SandiaFields> OptionalOS_PhotovoltaicPerformance_SandiaFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_PHOTOVOLTAICPERFORMANCE_SANDIA_FIELDENUMS_HXX
