/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SETPOINTMANAGER_SINGLEZONE_HUMIDITY_MAXIMUM_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SETPOINTMANAGER_SINGLEZONE_HUMIDITY_MAXIMUM_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SetpointManager_SingleZone_Humidity_MaximumFields
 *  \brief Enumeration of OS:SetpointManager:SingleZone:Humidity:Maximum's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SetpointManager_SingleZone_Humidity_MaximumFields, )
#else
class OS_SetpointManager_SingleZone_Humidity_MaximumFields: public ::EnumBase<OS_SetpointManager_SingleZone_Humidity_MaximumFields> {
 public: 
  enum domain 
  {
Handle, Name, ControlVariable, ControlZoneName, SetpointNodeorNodeListName,   };
  OS_SetpointManager_SingleZone_Humidity_MaximumFields()
   : EnumBase<OS_SetpointManager_SingleZone_Humidity_MaximumFields>(Handle) {} 
  OS_SetpointManager_SingleZone_Humidity_MaximumFields(const std::string &t_name) 
   : EnumBase<OS_SetpointManager_SingleZone_Humidity_MaximumFields>(t_name) {} 
  OS_SetpointManager_SingleZone_Humidity_MaximumFields(int t_value) 
   : EnumBase<OS_SetpointManager_SingleZone_Humidity_MaximumFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SetpointManager_SingleZone_Humidity_MaximumFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SetpointManager_SingleZone_Humidity_MaximumFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SetpointManager_SingleZone_Humidity_MaximumFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SetpointManager_SingleZone_Humidity_MaximumFields::Handle, "Handle", "Handle"},
{ OS_SetpointManager_SingleZone_Humidity_MaximumFields::Name, "Name", "Name"},
{ OS_SetpointManager_SingleZone_Humidity_MaximumFields::ControlVariable, "ControlVariable", "Control Variable"},
{ OS_SetpointManager_SingleZone_Humidity_MaximumFields::ControlZoneName, "ControlZoneName", "Control Zone Name"},
{ OS_SetpointManager_SingleZone_Humidity_MaximumFields::SetpointNodeorNodeListName, "SetpointNodeorNodeListName", "Setpoint Node or NodeList Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SetpointManager_SingleZone_Humidity_MaximumFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SetpointManager_SingleZone_Humidity_MaximumFields> OptionalOS_SetpointManager_SingleZone_Humidity_MaximumFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SETPOINTMANAGER_SINGLEZONE_HUMIDITY_MAXIMUM_FIELDENUMS_HXX
